/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.path;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPathConverter;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingRoot;
import java.util.List;
import lombok.NonNull;

public final class StagingPath {
    private final StagingRoot root;
    private final List<String> components;

    public static StagingPath of(@NonNull StagingRoot root, @NonNull List<String> components) {
        if (root == null) {
            throw new NullPointerException("root");
        }
        if (components == null) {
            throw new NullPointerException("components");
        }
        Preconditions.checkArgument(components.stream().noneMatch(String::isEmpty), "Components must not contain any empty components: %s", components);
        return new StagingPath(root, ImmutableList.copyOf(components));
    }

    public boolean isRoot() {
        return this.components.isEmpty();
    }

    public String toString() {
        return StagingPathConverter.defaultConverter().toHadoopPath(this).toString();
    }

    public StagingRoot getRoot() {
        return this.root;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StagingPath)) {
            return false;
        }
        StagingPath other = (StagingPath)o;
        StagingRoot this$root = this.getRoot();
        StagingRoot other$root = other.getRoot();
        if (this$root == null ? other$root != null : !((Object)this$root).equals(other$root)) {
            return false;
        }
        List<String> this$components = this.getComponents();
        List<String> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StagingRoot $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
        List<String> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    private StagingPath(StagingRoot root, List<String> components) {
        this.root = root;
        this.components = components;
    }
}

