/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.path;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Iterables;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPath;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPathConverter;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingRoot;
import com.amazon.ws.emr.hadoop.fs.util.HadoopPaths;
import java.net.URI;
import java.util.List;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;

final class PrefixStagingPathConverter
implements StagingPathConverter {
    private static final String DEFAULT_PREFIX = ".emrfs_staging_";
    private static final PrefixStagingPathConverter INSTANCE = new PrefixStagingPathConverter(".emrfs_staging_");
    private final String prefix;

    PrefixStagingPathConverter(@NonNull String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        Preconditions.checkArgument(!prefix.isEmpty(), "Prefix cannot be empty");
        this.prefix = prefix;
    }

    static PrefixStagingPathConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isStagingPath(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        List<String> pathComponents = HadoopPaths.getComponentsOfAbsolutePath(path);
        return this.indexOfStagingComponent(pathComponents) >= 0;
    }

    @Override
    public StagingPath toStagingPath(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        HadoopPaths.checkNotOpaque(path);
        Preconditions.checkArgument(HadoopPaths.isFullyQualified(path), "Path (%s) must be fully qualified", path);
        List<String> components = HadoopPaths.getComponentsOfAbsolutePath(path);
        int index = this.indexOfStagingComponent(components);
        Preconditions.checkArgument(index >= 0, "Path (%s) is not under a staging directory", path);
        Path outputPath = this.toFullyQualifiedPath(path.toUri(), components.subList(0, index));
        String stagingName = components.get(index).substring(this.prefix.length());
        Preconditions.checkArgument(!stagingName.isEmpty(), "Stage name cannot be empty (path: %s)", path);
        List<String> stagingComponents = components.subList(index + 1, components.size());
        return StagingPath.of(StagingRoot.of(outputPath, stagingName), stagingComponents);
    }

    @Override
    public Path toHadoopPath(@NonNull StagingPath stagingPath) {
        if (stagingPath == null) {
            throw new NullPointerException("stagingPath");
        }
        return this.toHadoopPath(stagingPath.getRoot(), stagingPath.getComponents());
    }

    @Override
    public Path toHadoopPath(@NonNull StagingRoot stagingRoot) {
        if (stagingRoot == null) {
            throw new NullPointerException("stagingRoot");
        }
        return this.toHadoopPath(stagingRoot, ImmutableList.of());
    }

    private Path toHadoopPath(StagingRoot root, List<String> components) {
        return new Path(root.getOutputPath(), Joiner.on("/").join(this.getStagingComponents(root, components)));
    }

    private Iterable<String> getStagingComponents(StagingRoot root, List<String> components) {
        return Iterables.concat(ImmutableList.of(this.prefix + root.getStageName()), components);
    }

    private int indexOfStagingComponent(List<String> pathComponents) {
        return Iterables.indexOf(pathComponents, component -> Preconditions.checkNotNull(component).startsWith(this.prefix));
    }

    private Path toFullyQualifiedPath(URI uri, List<String> components) {
        return HadoopPaths.toFullyQualifiedPath(uri.getScheme(), uri.getAuthority(), components);
    }
}

