/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory;

import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagedFileHandle;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingStatus;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.UploadMetadata;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory.StagingDirectory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;

public final class SynchronizedStagingDirectory
implements StagingDirectory {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    @NonNull
    private final StagingDirectory directory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StagedFileHandle createFile(List<String> pathComponents, boolean overwrite) throws IOException {
        this.lock.writeLock().lock();
        try {
            SynchronizedStagedFileHandle synchronizedStagedFileHandle = new SynchronizedStagedFileHandle(this.directory.createFile(pathComponents, overwrite));
            return synchronizedStagedFileHandle;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public StagingStatus getStatus(List<String> pathComponents) throws IOException {
        this.lock.readLock().lock();
        try {
            StagingStatus stagingStatus = this.directory.getStatus(pathComponents);
            return stagingStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void publish() throws IOException {
        this.lock.writeLock().lock();
        try {
            this.directory.publish();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void delete() throws IOException {
        this.lock.writeLock().lock();
        try {
            this.directory.delete();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public SynchronizedStagingDirectory(@NonNull StagingDirectory directory) {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        this.directory = directory;
    }

    private final class SynchronizedStagedFileHandle
    implements StagedFileHandle {
        private final StagedFileHandle handle;

        @Override
        public void complete(UploadMetadata uploadMetadata) throws IOException {
            SynchronizedStagingDirectory.this.lock.writeLock().lock();
            try {
                this.handle.complete(uploadMetadata);
            }
            finally {
                SynchronizedStagingDirectory.this.lock.writeLock().unlock();
            }
        }

        public SynchronizedStagedFileHandle(StagedFileHandle handle) {
            this.handle = handle;
        }
    }
}

