/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory;

import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagedFileHandle;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.UploadMetadata;
import java.io.IOException;
import lombok.NonNull;

final class StateAwareStagedFileHandle
implements StagedFileHandle {
    @NonNull
    private final StagedFileHandle fileHandle;
    private State state = State.PENDING;

    @Override
    public void complete(@NonNull UploadMetadata uploadMetadata) throws IOException {
        if (uploadMetadata == null) {
            throw new NullPointerException("uploadMetadata");
        }
        this.checkPending();
        try {
            this.fileHandle.complete(uploadMetadata);
            this.state = State.COMPLETED;
        }
        catch (IOException | RuntimeException e) {
            this.state = State.IN_ERROR;
            throw e;
        }
    }

    private void checkPending() throws IOException {
        if (this.state != State.PENDING) {
            throw new IOException(String.format("%s must be %s but is %s", new Object[]{this.fileHandle, State.PENDING, this.state}));
        }
    }

    public StateAwareStagedFileHandle(@NonNull StagedFileHandle fileHandle) {
        if (fileHandle == null) {
            throw new NullPointerException("fileHandle");
        }
        this.fileHandle = fileHandle;
    }

    private static enum State {
        PENDING,
        COMPLETED,
        IN_ERROR;

    }
}

