/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.NonNull;

final class Key
implements Comparable<Key> {
    private static final String DELIMITER = "/";
    private final List<String> components;

    static Key of(@NonNull List<String> components) {
        if (components == null) {
            throw new NullPointerException("components");
        }
        return new Key(ImmutableList.copyOf(components));
    }

    public String toString() {
        return Joiner.on(DELIMITER).join(this.components);
    }

    @Override
    public int compareTo(Key other) {
        int size1 = this.components.size();
        int size2 = other.components.size();
        int minSize = Math.min(size1, size2);
        for (int i = 0; i < minSize; ++i) {
            int componentComparision = this.components.get(i).compareTo(other.components.get(i));
            if (componentComparision == 0) continue;
            return componentComparision;
        }
        return size1 - size2;
    }

    boolean startsWith(Key key) {
        if (this.components.size() < key.components.size()) {
            return false;
        }
        for (int i = 0; i < key.components.size(); ++i) {
            if (this.components.get(i).equals(key.components.get(i))) continue;
            return false;
        }
        return true;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key other = (Key)o;
        List<String> this$components = this.getComponents();
        List<String> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    private Key(List<String> components) {
        this.components = components;
    }
}

