/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.MultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagedFileHandle;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingMetadataStore;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingStatus;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.UploadMetadata;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.exception.ClosedStagingMetadataStoreException;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory.InMemoryStagingDirectory;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory.StagingDirectory;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory.StagingDirectoryFactory;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.inmemory.SynchronizedStagingDirectory;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPath;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingRoot;
import com.amazon.ws.emr.hadoop.fs.util.ExceptionCollector;
import com.amazon.ws.emr.hadoop.fs.util.Uris;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.apache.hadoop.fs.staging.StagingDirectoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryStagingMetadataStore
implements StagingMetadataStore {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryStagingMetadataStore.class);
    private final Map<StagingRoot, StagingDirectory> directories = new ConcurrentHashMap<StagingRoot, StagingDirectory>();
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final URI uri;
    private final MultipartUploadDispatcher uploadDispatcher;
    private final StagingDirectoryFactory directoryFactory;

    InMemoryStagingMetadataStore(@NonNull URI uri, @NonNull MultipartUploadDispatcher uploadDispatcher, @NonNull StagingDirectoryFactory directoryFactory) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (uploadDispatcher == null) {
            throw new NullPointerException("uploadDispatcher");
        }
        if (directoryFactory == null) {
            throw new NullPointerException("directoryFactory");
        }
        Preconditions.checkArgument(uri.getScheme() != null, "URI (%s) must have a scheme", uri);
        Preconditions.checkArgument(uri.getAuthority() != null, "URI (%s) must have an authority", uri);
        this.uri = Uris.withOriginOnly(uri);
        this.uploadDispatcher = uploadDispatcher;
        this.directoryFactory = directoryFactory;
    }

    public static InMemoryStagingMetadataStore newInstance(URI uri, MultipartUploadDispatcher uploadDispatcher) {
        return new InMemoryStagingMetadataStore(uri, uploadDispatcher, InMemoryStagingDirectory::new);
    }

    @Override
    public void makeStagingDirectory(@NonNull StagingRoot root) throws IOException {
        if (root == null) {
            throw new NullPointerException("root");
        }
        this.checkOpen();
        this.checkStagingRoot(root);
        StagingDirectory directory = this.directories.computeIfAbsent(root, this::createStagingDirectory);
        this.checkOpenAndRollbackMakingDirectoryIfClosed(root, directory);
    }

    @Override
    public boolean hasStagingDirectory(StagingRoot root) throws IOException {
        this.checkOpen();
        this.checkStagingRoot(root);
        return this.directories.containsKey(root);
    }

    @Override
    public void publishStagingDirectory(@NonNull StagingRoot root) throws IOException {
        if (root == null) {
            throw new NullPointerException("root");
        }
        this.checkOpen();
        this.checkStagingRoot(root);
        this.getDirectoryOrFail(root).publish();
    }

    @Override
    public void deleteStagingDirectory(StagingRoot root) throws IOException {
        this.checkOpen();
        this.checkStagingRoot(root);
        StagingDirectory directory = this.directories.remove(root);
        if (directory != null) {
            directory.delete();
        }
    }

    @Override
    public StagedFileHandle createFile(@NonNull StagingPath path, boolean overwrite) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.checkOpen();
        this.checkStagingRoot(path.getRoot());
        StagingDirectory directory = this.getDirectoryOrFail(path.getRoot());
        StagedFileHandle handle = directory.createFile(path.getComponents(), overwrite);
        return new CloseAwareStagedFileHandle(handle);
    }

    @Override
    public StagingStatus getStatus(@NonNull StagingPath path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.checkOpen();
        this.checkStagingRoot(path.getRoot());
        return this.getDirectoryOrFail(path.getRoot()).getStatus(path.getComponents());
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen.compareAndSet(true, false)) {
            this.deleteAllDirectoriesWhileClosing();
        }
    }

    private void checkOpen() throws IOException {
        if (!this.isOpen.get()) {
            throw new ClosedStagingMetadataStoreException();
        }
    }

    private void checkStagingRoot(StagingRoot root) {
        URI outputUri = root.getOutputPath().toUri();
        String scheme = outputUri.getScheme();
        String authority = outputUri.getAuthority();
        Preconditions.checkArgument(scheme.equals(this.uri.getScheme()) && authority.equals(this.uri.getAuthority()), "Staging root (%s) must be under %s", root, this.uri);
    }

    private StagingDirectory createStagingDirectory(StagingRoot root) {
        return new SynchronizedStagingDirectory(this.directoryFactory.create(root, this.uploadDispatcher));
    }

    private void checkOpenAndRollbackMakingDirectoryIfClosed(StagingRoot root, StagingDirectory directory) throws IOException {
        if (this.isOpen.get()) {
            return;
        }
        logger.debug("Detected another thread had closed us while making a staging directory at '{}'", (Object)root);
        ClosedStagingMetadataStoreException toThrow = new ClosedStagingMetadataStoreException();
        try {
            if (this.directories.remove(root, directory)) {
                logger.debug("Deleting the staging directory (that we may have created) at '{}'", (Object)root);
                directory.delete();
            } else {
                logger.debug("Another thread already deleted the staging directory (that we may have created) at '{}'", (Object)root);
            }
        }
        catch (IOException | RuntimeException e) {
            logger.warn("Failed to delete a staging directory at '{}' (that we may have created while we were closed by another thread)", (Object)root, (Object)e);
            toThrow.addSuppressed(e);
        }
        throw toThrow;
    }

    private StagingDirectory getDirectoryOrFail(StagingRoot root) throws IOException {
        StagingDirectory directory = this.directories.get(root);
        if (directory == null) {
            throw InMemoryStagingMetadataStore.newDirectoryNotFoundException(root);
        }
        return directory;
    }

    private void deleteAllDirectoriesWhileClosing() throws IOException {
        assert (!this.isOpen.get());
        ExceptionCollector exceptionCollector = new ExceptionCollector();
        try {
            this.deleteAllDirectories(exceptionCollector);
        }
        catch (RuntimeException e) {
            exceptionCollector.add(e);
        }
        finally {
            exceptionCollector.throwIfNotEmpty(() -> new IOException("Failed to delete one or more staging directories while closing"));
        }
    }

    private void deleteAllDirectories(ExceptionCollector exceptionCollector) {
        Iterator<Map.Entry<StagingRoot, StagingDirectory>> iterator = this.directories.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<StagingRoot, StagingDirectory> entry = iterator.next();
            try {
                entry.getValue().delete();
            }
            catch (IOException | RuntimeException e) {
                logger.warn("Failed to delete staging directory at '{}'", (Object)entry.getKey(), (Object)e);
                exceptionCollector.add(e);
            }
            iterator.remove();
        }
    }

    private static StagingDirectoryNotFoundException newDirectoryNotFoundException(StagingRoot root) {
        return new StagingDirectoryNotFoundException(root.getOutputPath(), root.getStageName());
    }

    private final class CloseAwareStagedFileHandle
    implements StagedFileHandle {
        private final StagedFileHandle delegate;

        @Override
        public void complete(UploadMetadata uploadMetadata) throws IOException {
            InMemoryStagingMetadataStore.this.checkOpen();
            this.delegate.complete(uploadMetadata);
        }

        public CloseAwareStagedFileHandle(StagedFileHandle delegate) {
            this.delegate = delegate;
        }
    }
}

