/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PartETag;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.List;
import lombok.NonNull;

public final class UploadMetadata {
    private final String uploadId;
    private final List<PartETag> partETags;
    private final long totalLength;

    public static UploadMetadata of(@NonNull String uploadId, @NonNull List<PartETag> partETags, long totalLength) {
        if (uploadId == null) {
            throw new NullPointerException("uploadId");
        }
        if (partETags == null) {
            throw new NullPointerException("partETags");
        }
        Preconditions.checkArgument(totalLength >= 0L, "TotalLength must not be negative");
        return new UploadMetadata(uploadId, partETags, totalLength);
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public List<PartETag> getPartETags() {
        return this.partETags;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadMetadata)) {
            return false;
        }
        UploadMetadata other = (UploadMetadata)o;
        String this$uploadId = this.getUploadId();
        String other$uploadId = other.getUploadId();
        if (this$uploadId == null ? other$uploadId != null : !this$uploadId.equals(other$uploadId)) {
            return false;
        }
        List<PartETag> this$partETags = this.getPartETags();
        List<PartETag> other$partETags = other.getPartETags();
        if (this$partETags == null ? other$partETags != null : !((Object)this$partETags).equals(other$partETags)) {
            return false;
        }
        return this.getTotalLength() == other.getTotalLength();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uploadId = this.getUploadId();
        result = result * 59 + ($uploadId == null ? 43 : $uploadId.hashCode());
        List<PartETag> $partETags = this.getPartETags();
        result = result * 59 + ($partETags == null ? 43 : ((Object)$partETags).hashCode());
        long $totalLength = this.getTotalLength();
        result = result * 59 + (int)($totalLength >>> 32 ^ $totalLength);
        return result;
    }

    public String toString() {
        return "UploadMetadata(uploadId=" + this.getUploadId() + ", partETags=" + this.getPartETags() + ", totalLength=" + this.getTotalLength() + ")";
    }

    private UploadMetadata(String uploadId, List<PartETag> partETags, long totalLength) {
        this.uploadId = uploadId;
        this.partETags = partETags;
        this.totalLength = totalLength;
    }
}

