/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging.metadata;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPath;
import lombok.NonNull;

public final class StagingStatus {
    @NonNull
    private final StagingPath path;
    private final boolean isDirectory;
    private final long length;
    private final long modificationTime;

    public static StagingStatus forDirectory(StagingPath path) {
        return new StagingStatus(path, true, 0L, 0L);
    }

    public static StagingStatus forFile(@NonNull StagingPath path, long length, long modificationTime) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        Preconditions.checkArgument(!path.isRoot(), "Path (%s) must not be a root staging path", path);
        Preconditions.checkArgument(length >= 0L, "Length (%s) must not be negative", length);
        return new StagingStatus(path, false, length, modificationTime);
    }

    public StagingStatus(@NonNull StagingPath path, boolean isDirectory, long length, long modificationTime) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.isDirectory = isDirectory;
        this.length = length;
        this.modificationTime = modificationTime;
    }

    @NonNull
    public StagingPath getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long getLength() {
        return this.length;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StagingStatus)) {
            return false;
        }
        StagingStatus other = (StagingStatus)o;
        StagingPath this$path = this.getPath();
        StagingPath other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        if (this.isDirectory() != other.isDirectory()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        return this.getModificationTime() == other.getModificationTime();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StagingPath $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        result = result * 59 + (this.isDirectory() ? 79 : 97);
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        long $modificationTime = this.getModificationTime();
        result = result * 59 + (int)($modificationTime >>> 32 ^ $modificationTime);
        return result;
    }

    public String toString() {
        return "StagingStatus(path=" + this.getPath() + ", isDirectory=" + this.isDirectory() + ", length=" + this.getLength() + ", modificationTime=" + this.getModificationTime() + ")";
    }
}

