/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.UploadMetadata;
import lombok.NonNull;

public final class DeferredUpload {
    @NonNull
    private final UploadMetadata metadata;
    private final long deferralTime;
    private Long completedTime;

    public void setCompletedTime(long completedTime) {
        Preconditions.checkState(!this.isCompleted(), "upload is already completed");
        Preconditions.checkArgument(completedTime >= this.deferralTime, "completedTime must be >= deferralTime");
        this.completedTime = completedTime;
    }

    public boolean isCompleted() {
        return this.completedTime != null;
    }

    @NonNull
    public UploadMetadata getMetadata() {
        return this.metadata;
    }

    public long getDeferralTime() {
        return this.deferralTime;
    }

    public Long getCompletedTime() {
        return this.completedTime;
    }

    public DeferredUpload(@NonNull UploadMetadata metadata, long deferralTime) {
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        this.metadata = metadata;
        this.deferralTime = deferralTime;
    }
}

