/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.staging;

import com.amazon.ws.emr.hadoop.fs.s3n.FileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.staging.StagingMechanism;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingMetadataStore;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingStatus;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPath;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPathConverter;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingRoot;
import java.io.IOException;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.staging.UnsupportedStagingDirectoryOperationException;

public final class DefaultStagingMechanism
implements StagingMechanism {
    @NonNull
    private final StagingPathConverter pathConverter;
    @NonNull
    private final StagingMetadataStore store;
    @NonNull
    private final UnaryOperator<Path> pathQualifier;
    @NonNull
    private final FileStatusFactory fileStatusFactory;

    public boolean isStagingDirectoryPath(@Nonnull Path path) {
        Path qualifiedPath = (Path)this.pathQualifier.apply(path);
        return this.pathConverter.isStagingPath(qualifiedPath);
    }

    public boolean hasStagingDirectory(@Nonnull Path destinationPath, @Nonnull String stageName) throws IOException {
        return this.store.hasStagingDirectory(this.getStagingRoot(destinationPath, stageName));
    }

    public Path makeStagingDirectory(@Nonnull Path destinationPath, @Nonnull String stageName) throws IOException {
        Path qualifiedDestinationPath = (Path)this.pathQualifier.apply(destinationPath);
        if (this.pathConverter.isStagingPath(qualifiedDestinationPath)) {
            throw new UnsupportedStagingDirectoryOperationException(String.format("Cannot create a staging directory under a staging directory (destinationPath: %s, stageName: %s)", qualifiedDestinationPath, stageName));
        }
        StagingRoot stagingRoot = StagingRoot.of(qualifiedDestinationPath, stageName);
        this.store.makeStagingDirectory(stagingRoot);
        return this.pathConverter.toHadoopPath(stagingRoot);
    }

    public void publishStagingDirectory(@Nonnull Path outputPath, @Nonnull String stageName) throws IOException {
        this.store.publishStagingDirectory(this.getStagingRoot(outputPath, stageName));
    }

    public void deleteStagingDirectory(@Nonnull Path destinationPath, @Nonnull String stageName) throws IOException {
        this.store.deleteStagingDirectory(this.getStagingRoot(destinationPath, stageName));
    }

    @Override
    public FileStatus getFileStatus(@Nonnull Path path) throws IOException {
        Path qualifiedDestinationPath = (Path)this.pathQualifier.apply(path);
        StagingPath stagingPath = this.pathConverter.toStagingPath(qualifiedDestinationPath);
        return this.toFileStatus(this.store.getStatus(stagingPath));
    }

    private StagingRoot getStagingRoot(Path destinationPath, String stageName) {
        Path qualifiedDestinationPath = (Path)this.pathQualifier.apply(destinationPath);
        return StagingRoot.of(qualifiedDestinationPath, stageName);
    }

    private FileStatus toFileStatus(StagingStatus status) {
        Path path = this.pathConverter.toHadoopPath(status.getPath());
        if (status.isDirectory()) {
            return this.fileStatusFactory.newDirectory(path);
        }
        return this.fileStatusFactory.newFile(path, status.getLength(), status.getModificationTime());
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    DefaultStagingMechanism(@NonNull StagingPathConverter pathConverter, @NonNull StagingMetadataStore store, @NonNull UnaryOperator<Path> pathQualifier, @NonNull FileStatusFactory fileStatusFactory) {
        if (pathConverter == null) {
            throw new NullPointerException("pathConverter");
        }
        if (store == null) {
            throw new NullPointerException("store");
        }
        if (pathQualifier == null) {
            throw new NullPointerException("pathQualifier");
        }
        if (fileStatusFactory == null) {
            throw new NullPointerException("fileStatusFactory");
        }
        this.pathConverter = pathConverter;
        this.store = store;
        this.pathQualifier = pathQualifier;
        this.fileStatusFactory = fileStatusFactory;
    }

    public static DefaultStagingMechanismBuilder builder() {
        return new DefaultStagingMechanismBuilder();
    }

    public static class DefaultStagingMechanismBuilder {
        private StagingPathConverter pathConverter;
        private StagingMetadataStore store;
        private UnaryOperator<Path> pathQualifier;
        private FileStatusFactory fileStatusFactory;

        DefaultStagingMechanismBuilder() {
        }

        public DefaultStagingMechanismBuilder pathConverter(StagingPathConverter pathConverter) {
            this.pathConverter = pathConverter;
            return this;
        }

        public DefaultStagingMechanismBuilder store(StagingMetadataStore store) {
            this.store = store;
            return this;
        }

        public DefaultStagingMechanismBuilder pathQualifier(UnaryOperator<Path> pathQualifier) {
            this.pathQualifier = pathQualifier;
            return this;
        }

        public DefaultStagingMechanismBuilder fileStatusFactory(FileStatusFactory fileStatusFactory) {
            this.fileStatusFactory = fileStatusFactory;
            return this;
        }

        public DefaultStagingMechanism build() {
            return new DefaultStagingMechanism(this.pathConverter, this.store, this.pathQualifier, this.fileStatusFactory);
        }

        public String toString() {
            return "DefaultStagingMechanism.DefaultStagingMechanismBuilder(pathConverter=" + this.pathConverter + ", store=" + this.store + ", pathQualifier=" + this.pathQualifier + ", fileStatusFactory=" + this.fileStatusFactory + ")";
        }
    }
}

