/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode;

import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.MathRuntimeException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.linear.Array2DRowRealMatrix;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.linear.RealMatrix;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode.DerivativeException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode.FirstOrderIntegrator;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode.IntegratorException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode.ODEIntegrator;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode.nonstiff.AdaptiveStepsizeIntegrator;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode.nonstiff.DormandPrince853Integrator;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode.sampling.StepHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.ode.sampling.StepInterpolator;

public abstract class MultistepIntegrator
extends AdaptiveStepsizeIntegrator {
    protected double[] scaled;
    protected Array2DRowRealMatrix nordsieck;
    private FirstOrderIntegrator starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(name, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        if (nSteps <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} method needs at least one previous point", name);
        }
        this.starter = new DormandPrince853Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(Math.pow(2.0, -this.exp));
    }

    protected MultistepIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(name, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.starter = new DormandPrince853Integrator(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(Math.pow(2.0, -this.exp));
    }

    public ODEIntegrator getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(FirstOrderIntegrator starterIntegrator) {
        this.starter = starterIntegrator;
    }

    protected void start(double t0, double[] y0, double t) throws DerivativeException, IntegratorException {
        block2: {
            this.starter.clearEventHandlers();
            this.starter.clearStepHandlers();
            this.starter.addStepHandler(new NordsieckInitializer(y0.length));
            try {
                this.starter.integrate(new CountingDifferentialEquations(y0.length), t0, y0, t, new double[y0.length]);
            }
            catch (DerivativeException de) {
                if (de instanceof InitializationCompletedMarkerException) break block2;
                throw de;
            }
        }
        this.starter.clearStepHandlers();
    }

    protected abstract Array2DRowRealMatrix initializeHighOrderDerivatives(double[] var1, double[][] var2);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double minReduction) {
        this.minReduction = minReduction;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double safety) {
        this.safety = safety;
    }

    protected double computeStepGrowShrinkFactor(double error) {
        return Math.min(this.maxGrowth, Math.max(this.minReduction, this.safety * Math.pow(error, this.exp)));
    }

    private class CountingDifferentialEquations
    implements FirstOrderDifferentialEquations {
        private final int dimension;

        public CountingDifferentialEquations(int dimension) {
            this.dimension = dimension;
        }

        public void computeDerivatives(double t, double[] y, double[] dot) throws DerivativeException {
            MultistepIntegrator.this.computeDerivatives(t, y, dot);
        }

        public int getDimension() {
            return this.dimension;
        }
    }

    private static class InitializationCompletedMarkerException
    extends DerivativeException {
        private static final long serialVersionUID = -4105805787353488365L;

        public InitializationCompletedMarkerException() {
            super((Throwable)null);
        }
    }

    private class NordsieckInitializer
    implements StepHandler {
        private final int n;

        public NordsieckInitializer(int n) {
            this.n = n;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) throws DerivativeException {
            double prev = interpolator.getPreviousTime();
            double curr = interpolator.getCurrentTime();
            MultistepIntegrator.this.stepStart = prev;
            MultistepIntegrator.this.stepSize = (curr - prev) / (double)(MultistepIntegrator.this.nSteps + 1);
            interpolator.setInterpolatedTime(prev);
            MultistepIntegrator.this.scaled = (double[])interpolator.getInterpolatedDerivatives().clone();
            int j = 0;
            while (j < this.n) {
                int n = j++;
                MultistepIntegrator.this.scaled[n] = MultistepIntegrator.this.scaled[n] * MultistepIntegrator.this.stepSize;
            }
            double[][] multistep = new double[MultistepIntegrator.this.nSteps][];
            for (int i = 1; i <= MultistepIntegrator.this.nSteps; ++i) {
                interpolator.setInterpolatedTime(prev + MultistepIntegrator.this.stepSize * (double)i);
                double[] msI = (double[])interpolator.getInterpolatedDerivatives().clone();
                int j2 = 0;
                while (j2 < this.n) {
                    int n = j2++;
                    msI[n] = msI[n] * MultistepIntegrator.this.stepSize;
                }
                multistep[i - 1] = msI;
            }
            MultistepIntegrator.this.nordsieck = MultistepIntegrator.this.initializeHighOrderDerivatives(MultistepIntegrator.this.scaled, multistep);
            throw new InitializationCompletedMarkerException();
        }

        public boolean requiresDenseOutput() {
            return true;
        }

        public void reset() {
        }
    }

    public static interface NordsieckTransformer {
        public RealMatrix initializeHighOrderDerivatives(double[] var1, double[][] var2);
    }
}

