/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.genetics;

import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.genetics.AbstractListChromosome;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.genetics.BinaryChromosome;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.genetics.Chromosome;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.genetics.GeneticAlgorithm;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.genetics.MutationPolicy;
import java.util.ArrayList;

public class BinaryMutation
implements MutationPolicy {
    public Chromosome mutate(Chromosome original) {
        if (!(original instanceof BinaryChromosome)) {
            throw new IllegalArgumentException("Binary mutation works on BinaryChromosome only.");
        }
        BinaryChromosome origChrom = (BinaryChromosome)original;
        ArrayList newRepr = new ArrayList(origChrom.getRepresentation());
        int geneIndex = GeneticAlgorithm.getRandomGenerator().nextInt(origChrom.getLength());
        newRepr.set(geneIndex, (Integer)origChrom.getRepresentation().get(geneIndex) == 0 ? 1 : 0);
        AbstractListChromosome newChrom = origChrom.newFixedLengthChromosome(newRepr);
        return newChrom;
    }
}

