/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.distribution;

import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.MathException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.MathRuntimeException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.distribution.AbstractIntegerDistribution;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.distribution.NormalDistribution;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.distribution.NormalDistributionImpl;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.distribution.PoissonDistribution;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.distribution.SaddlePointExpansion;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.math.special.Gamma;
import java.io.Serializable;

public class PoissonDistributionImpl
extends AbstractIntegerDistribution
implements PoissonDistribution,
Serializable {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private NormalDistribution normal;
    private double mean;
    private int maxIterations = 10000000;
    private double epsilon = 1.0E-12;

    public PoissonDistributionImpl(double p) {
        this(p, new NormalDistributionImpl());
    }

    public PoissonDistributionImpl(double p, double epsilon, int maxIterations) {
        this.setMean(p);
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
    }

    public PoissonDistributionImpl(double p, double epsilon) {
        this.setMean(p);
        this.epsilon = epsilon;
    }

    public PoissonDistributionImpl(double p, int maxIterations) {
        this.setMean(p);
        this.maxIterations = maxIterations;
    }

    @Deprecated
    public PoissonDistributionImpl(double p, NormalDistribution z) {
        this.setNormalAndMeanInternal(z, p);
    }

    public double getMean() {
        return this.mean;
    }

    @Deprecated
    public void setMean(double p) {
        this.setNormalAndMeanInternal(this.normal, p);
    }

    private void setNormalAndMeanInternal(NormalDistribution z, double p) {
        if (p <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("the Poisson mean must be positive ({0})", p);
        }
        this.mean = p;
        this.normal = z;
        this.normal.setMean(p);
        this.normal.setStandardDeviation(Math.sqrt(p));
    }

    public double probability(int x) {
        double ret = x < 0 || x == Integer.MAX_VALUE ? 0.0 : (x == 0 ? Math.exp(-this.mean) : Math.exp(-SaddlePointExpansion.getStirlingError(x) - SaddlePointExpansion.getDeviancePart(x, this.mean)) / Math.sqrt(Math.PI * 2 * (double)x));
        return ret;
    }

    public double cumulativeProbability(int x) throws MathException {
        if (x < 0) {
            return 0.0;
        }
        if (x == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)x + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int x) throws MathException {
        return this.normal.cumulativeProbability((double)x + 0.5);
    }

    protected int getDomainLowerBound(double p) {
        return 0;
    }

    protected int getDomainUpperBound(double p) {
        return Integer.MAX_VALUE;
    }

    @Deprecated
    public void setNormal(NormalDistribution value) {
        this.setNormalAndMeanInternal(value, this.mean);
    }
}

