/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec;

import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.ExecuteException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.ExecuteStreamHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.InputStreamPumper;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.StreamPumper;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.util.DebugUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private static final long STOP_TIMEOUT_ADDITION = 2000L;
    private Thread outputThread;
    private Thread errorThread;
    private Thread inputThread;
    private final OutputStream out;
    private final OutputStream err;
    private final InputStream input;
    private InputStreamPumper inputStreamPumper;
    private long stopTimeout;
    private IOException caught = null;

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this(out, err, null);
    }

    public PumpStreamHandler(OutputStream out, OutputStream err, InputStream input) {
        this.out = out;
        this.err = err;
        this.input = input;
    }

    public void setStopTimeout(long timeout) {
        this.stopTimeout = timeout;
    }

    public void setProcessOutputStream(InputStream is) {
        if (this.out != null) {
            this.createProcessOutputPump(is, this.out);
        }
    }

    public void setProcessErrorStream(InputStream is) {
        if (this.err != null) {
            this.createProcessErrorPump(is, this.err);
        }
    }

    public void setProcessInputStream(OutputStream os) {
        if (this.input != null) {
            this.inputThread = this.input == System.in ? this.createSystemInPump(this.input, os) : this.createPump(this.input, os, true);
        } else {
            try {
                os.close();
            }
            catch (IOException e) {
                String msg = "Got exception while closing output stream";
                DebugUtils.handleException("Got exception while closing output stream", e);
            }
        }
    }

    public void start() {
        if (this.outputThread != null) {
            this.outputThread.start();
        }
        if (this.errorThread != null) {
            this.errorThread.start();
        }
        if (this.inputThread != null) {
            this.inputThread.start();
        }
    }

    public void stop() throws IOException {
        String msg;
        if (this.inputStreamPumper != null) {
            this.inputStreamPumper.stopProcessing();
        }
        this.stopThread(this.outputThread, this.stopTimeout);
        this.stopThread(this.errorThread, this.stopTimeout);
        this.stopThread(this.inputThread, this.stopTimeout);
        if (this.err != null && this.err != this.out) {
            try {
                this.err.flush();
            }
            catch (IOException e) {
                msg = "Got exception while flushing the error stream : " + e.getMessage();
                DebugUtils.handleException(msg, e);
            }
        }
        if (this.out != null) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                msg = "Got exception while flushing the output stream";
                DebugUtils.handleException("Got exception while flushing the output stream", e);
            }
        }
        if (this.caught != null) {
            throw this.caught;
        }
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.outputThread = this.createPump(is, os);
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        boolean closeWhenExhausted = os instanceof PipedOutputStream;
        return this.createPump(is, os, closeWhenExhausted);
    }

    protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        Thread result = new Thread((Runnable)new StreamPumper(is, os, closeWhenExhausted), "Exec Stream Pumper");
        result.setDaemon(true);
        return result;
    }

    protected void stopThread(Thread thread, long timeout) {
        if (thread != null) {
            try {
                if (timeout == 0L) {
                    thread.join();
                } else {
                    long timeToWait = timeout + 2000L;
                    long startTime = System.currentTimeMillis();
                    thread.join(timeToWait);
                    if (System.currentTimeMillis() >= startTime + timeToWait) {
                        String msg = "The stop timeout of " + timeout + " ms was exceeded";
                        this.caught = new ExecuteException(msg, -559038737);
                    }
                }
            }
            catch (InterruptedException e) {
                thread.interrupt();
            }
        }
    }

    private Thread createSystemInPump(InputStream is, OutputStream os) {
        this.inputStreamPumper = new InputStreamPumper(is, os);
        Thread result = new Thread((Runnable)this.inputStreamPumper, "Exec Input Stream Pumper");
        result.setDaemon(true);
        return result;
    }
}

