/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.xspec;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.annotation.Immutable;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.xspec.PathElement;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;

@Immutable
final class NamedElement
extends PathElement {
    private final String name;

    NamedElement(String name) {
        if (name == null) {
            throw new NullPointerException("element");
        }
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("element cannot be empty");
        }
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NamedElement)) {
            return false;
        }
        return this.name.equals(((NamedElement)obj).name);
    }

    @Override
    String asNestedPath() {
        return "." + this.name;
    }

    @Override
    String asToken(SubstitutionContext context) {
        return context.nameTokenFor(this.name);
    }

    @Override
    String asNestedToken(SubstitutionContext context) {
        return "." + context.nameTokenFor(this.name);
    }
}

