/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.endpointdiscovery;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.endpointdiscovery.EndpointDiscoveryRefreshCache;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.endpointdiscovery.AmazonDynamoDBEndpointCacheLoader;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.logging.Log;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.logging.LogFactory;
import java.net.URI;
import java.util.Map;

public class AmazonDynamoDBEndpointCache
extends EndpointDiscoveryRefreshCache<String> {
    private static final Log log = LogFactory.getLog(AmazonDynamoDBEndpointCache.class);

    public AmazonDynamoDBEndpointCache(AmazonDynamoDB client) {
        super(new AmazonDynamoDBEndpointCacheLoader(client));
    }

    @Override
    public URI get(String key, boolean required, URI defaultEndpoint) {
        URI endpoint = (URI)this.cache.get(key);
        if (endpoint != null) {
            return endpoint;
        }
        if (!required) {
            this.cache.put(key, defaultEndpoint);
        }
        return this.discoverEndpoint(key, required, defaultEndpoint);
    }

    @Override
    public URI put(String key, Map<String, String> endpointDetails, URI defaultEndpoint) {
        this.loadAndScheduleRefresh(key, Long.valueOf(endpointDetails.get("CachePeriod")), defaultEndpoint);
        URI discoveredEndpoint = URI.create(String.format("%s://%s", defaultEndpoint.getScheme(), endpointDetails.get("Endpoint")));
        log.debug("Cached new endpoint from service: " + discoveredEndpoint.toASCIIString());
        log.debug("Refresh scheduled in: " + endpointDetails.get("CachePeriod") + " minutes");
        return this.cache.put(key, discoveredEndpoint);
    }
}

