/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.Page;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.internal.ScanPage;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.LinkedHashMap;
import java.util.Map;

class ScanCollection
extends ItemCollection<ScanOutcome> {
    private final AmazonDynamoDB client;
    private final ScanSpec spec;
    private final Map<String, AttributeValue> startKey;

    public ScanCollection(AmazonDynamoDB client, ScanSpec spec) {
        this.client = client;
        this.spec = spec;
        Map<String, AttributeValue> startKey = ((ScanRequest)spec.getRequest()).getExclusiveStartKey();
        this.startKey = startKey == null ? null : new LinkedHashMap<String, AttributeValue>(startKey);
    }

    @Override
    public Page<Item, ScanOutcome> firstPage() {
        ScanRequest request = (ScanRequest)this.spec.getRequest();
        request.setExclusiveStartKey(this.startKey);
        request.setLimit(InternalUtils.minimum(this.spec.getMaxResultSize(), this.spec.getMaxPageSize()));
        ScanResult result = this.client.scan(request);
        ScanOutcome outcome = new ScanOutcome(result);
        this.setLastLowLevelResult(outcome);
        return new ScanPage(this.client, this.spec, request, 0, outcome);
    }

    @Override
    public Integer getMaxResultSize() {
        return this.spec.getMaxResultSize();
    }

    @Override
    protected void setLastLowLevelResult(ScanOutcome lowLevelResult) {
        super.setLastLowLevelResult(lowLevelResult);
        ScanResult result = lowLevelResult.getScanResult();
        this.accumulateStats(result.getConsumedCapacity(), result.getCount(), result.getScannedCount());
    }
}

