/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class DynamoDBTypeConverterFactory {
    public abstract <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> var1, Class<T> var2);

    public final Builder override() {
        return new Builder(this);
    }

    public static final DynamoDBTypeConverterFactory standard() {
        return StandardTypeConverters.factory();
    }

    private static final class Key<S, T>
    extends AbstractMap.SimpleImmutableEntry<Class<S>, Class<T>> {
        private static final long serialVersionUID = -1L;

        private Key(Class<S> sourceType, Class<T> targetType) {
            super(sourceType, targetType);
        }

        public boolean isAssignableFrom(Class<?> sourceType, Class<?> targetType) {
            return ((Class)this.getKey()).isAssignableFrom(sourceType) && ((Class)this.getValue()).isAssignableFrom(targetType);
        }

        public static <S, T> Key<S, T> of(Class<S> sourceType, Class<T> targetType) {
            return new Key<S, T>(sourceType, targetType);
        }
    }

    private static final class ConverterMap
    extends LinkedHashMap<Key<?, ?>, DynamoDBTypeConverter<?, ?>> {
        private static final long serialVersionUID = -1L;

        private ConverterMap() {
        }

        public <S, T> void put(Class<S> sourceType, Class<T> targetType, DynamoDBTypeConverter<? extends S, ? extends T> converter) {
            this.put(Key.of(sourceType, targetType), converter);
        }

        public <S, T> DynamoDBTypeConverter<S, T> get(Class<S> sourceType, Class<T> targetType) {
            for (Map.Entry entry : this.entrySet()) {
                if (!((Key)entry.getKey()).isAssignableFrom(sourceType, targetType)) continue;
                return (DynamoDBTypeConverter)entry.getValue();
            }
            return null;
        }
    }

    private static class OverrideFactory
    extends DelegateFactory {
        private final ConverterMap overrides;

        public OverrideFactory(DynamoDBTypeConverterFactory defaults, ConverterMap overrides) {
            super(defaults);
            this.overrides = overrides;
        }

        @Override
        public <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            DynamoDBTypeConverter<S, T> converter = this.overrides.get(sourceType, targetType);
            if (converter == null) {
                converter = super.getConverter(sourceType, targetType);
            }
            return converter;
        }
    }

    public static class DelegateFactory
    extends DynamoDBTypeConverterFactory {
        private final DynamoDBTypeConverterFactory delegate;

        public DelegateFactory(DynamoDBTypeConverterFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            return this.delegate.getConverter(sourceType, targetType);
        }
    }

    public static final class Builder {
        private final ConverterMap overrides = new ConverterMap();
        private final DynamoDBTypeConverterFactory defaults;

        private Builder(DynamoDBTypeConverterFactory defaults) {
            this.defaults = defaults;
        }

        public <S, T> Builder with(Class<S> sourceType, Class<T> targetType, DynamoDBTypeConverter<? extends S, ? extends T> converter) {
            if (StandardTypeConverters.Vector.SET.is(sourceType) || StandardTypeConverters.Vector.LIST.is(sourceType) || StandardTypeConverters.Vector.MAP.is(sourceType)) {
                throw new DynamoDBMappingException("type [" + sourceType + "] is not supported; type-converter factory only supports scalar conversions");
            }
            this.overrides.put(sourceType, targetType, converter);
            return this;
        }

        public DynamoDBTypeConverterFactory build() {
            return new OverrideFactory(this.defaults, this.overrides);
        }
    }
}

