/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverted;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTyped;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.DateTime;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.DateTimeZone;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.format.DateTimeFormat;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.format.DateTimeFormatter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.TimeZone;

@DynamoDBTypeConverted(converter=Converter.class)
@DynamoDBTyped(value=DynamoDBMapperFieldModel.DynamoDBAttributeType.S)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBTypeConvertedTimestamp {
    public String pattern() default "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public String timeZone() default "UTC";

    public static final class Converter<T>
    implements DynamoDBTypeConverter<String, T> {
        private final DynamoDBTypeConverter<DateTime, T> converter;
        private final DateTimeFormatter formatter;

        public Converter(Class<T> targetType, DynamoDBTypeConvertedTimestamp annotation) {
            this.formatter = DateTimeFormat.forPattern(annotation.pattern()).withZone(DateTimeZone.forTimeZone((TimeZone)StandardTypeConverters.Scalar.TIME_ZONE.convert(annotation.timeZone())));
            this.converter = StandardTypeConverters.factory().getConverter(DateTime.class, targetType);
        }

        @Override
        public final String convert(T object) {
            return this.formatter.print(this.converter.convert(object));
        }

        @Override
        public final T unconvert(String object) {
            return this.converter.unconvert(this.formatter.parseDateTime(object));
        }
    }
}

