/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBSaveExpression;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.PaginatedParallelScanList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.QueryResultPage;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.ScanResultPage;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.TransactionLoadRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.datamodeling.TransactionWriteRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.logging.Log;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.logging.LogFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DynamoDBTableMapper<T, H, R> {
    private static final Log LOG = LogFactory.getLog(DynamoDBTableMapper.class);
    private final DynamoDBMapperTableModel<T> model;
    private final DynamoDBMapperFieldModel<T, H> hk;
    private final DynamoDBMapperFieldModel<T, R> rk;
    private final DynamoDBMapperConfig config;
    private final DynamoDBMapper mapper;
    private final AmazonDynamoDB db;

    protected DynamoDBTableMapper(AmazonDynamoDB db, DynamoDBMapper mapper, DynamoDBMapperConfig config, DynamoDBMapperTableModel<T> model) {
        this.rk = model.rangeKeyIfExists();
        this.hk = model.hashKey();
        this.model = model;
        this.config = config;
        this.mapper = mapper;
        this.db = db;
    }

    public <V> DynamoDBMapperFieldModel<T, V> field(String attributeName) {
        return this.model.field(attributeName);
    }

    public DynamoDBMapperFieldModel<T, H> hashKey() {
        return this.model.hashKey();
    }

    public DynamoDBMapperFieldModel<T, R> rangeKey() {
        return this.model.rangeKey();
    }

    public List<T> batchLoad(Iterable<T> itemsToGet) {
        Map<String, List<Object>> results = this.mapper.batchLoad(itemsToGet);
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        return results.get(this.mapper.getTableName(this.model.targetType(), this.config));
    }

    public List<DynamoDBMapper.FailedBatch> batchSave(Iterable<T> objectsToSave) {
        return this.mapper.batchWrite(objectsToSave, Collections.emptyList());
    }

    public List<DynamoDBMapper.FailedBatch> batchDelete(Iterable<T> objectsToDelete) {
        return this.mapper.batchWrite(Collections.emptyList(), objectsToDelete);
    }

    public List<DynamoDBMapper.FailedBatch> batchWrite(Iterable<T> objectsToWrite, Iterable<T> objectsToDelete) {
        return this.mapper.batchWrite(objectsToWrite, objectsToDelete);
    }

    public void transactionWrite(TransactionWriteRequest transactionWriteRequest) {
        for (TransactionWriteRequest.TransactionWriteOperation transactionWriteOperation : transactionWriteRequest.getTransactionWriteOperations()) {
            if (this.model.targetType().equals(transactionWriteOperation.getObject().getClass())) continue;
            throw new DynamoDBMappingException("Input object is of the classType: " + transactionWriteOperation.getObject().getClass() + " but tableMapper is declared with classType: " + this.model.targetType());
        }
        this.mapper.transactionWrite(transactionWriteRequest);
    }

    public List<Object> transactionLoad(TransactionLoadRequest transactionLoadRequest) {
        for (Object object : transactionLoadRequest.getObjectsToLoad()) {
            if (this.model.targetType().equals(object.getClass())) continue;
            throw new DynamoDBMappingException("Input object is of the classType: " + object.getClass() + " but tableMapper is declared with classType: " + this.model.targetType());
        }
        return this.mapper.transactionLoad(transactionLoadRequest);
    }

    public T load(H hashKey) {
        return this.mapper.load(this.model.targetType(), hashKey);
    }

    public T load(H hashKey, R rangeKey) {
        return this.mapper.load(this.model.targetType(), hashKey, rangeKey);
    }

    public void save(T object) {
        this.mapper.save(object);
    }

    public void save(T object, DynamoDBSaveExpression saveExpression) {
        this.mapper.save(object, saveExpression);
    }

    public void saveIfNotExists(T object) throws ConditionalCheckFailedException {
        DynamoDBSaveExpression saveExpression = new DynamoDBSaveExpression();
        for (DynamoDBMapperFieldModel<T, Object> key : this.model.keys()) {
            saveExpression.withExpectedEntry(key.name(), new ExpectedAttributeValue().withExists(false));
        }
        this.mapper.save(object, saveExpression);
    }

    public void saveIfExists(T object) throws ConditionalCheckFailedException {
        DynamoDBSaveExpression saveExpression = new DynamoDBSaveExpression();
        for (DynamoDBMapperFieldModel<T, Object> key : this.model.keys()) {
            saveExpression.withExpectedEntry(key.name(), new ExpectedAttributeValue().withExists(true).withValue((AttributeValue)key.convert(key.get(object))));
        }
        this.mapper.save(object, saveExpression);
    }

    public final void delete(T object) {
        this.mapper.delete(object);
    }

    public final void delete(T object, DynamoDBDeleteExpression deleteExpression) {
        this.mapper.delete(object, deleteExpression);
    }

    public void deleteIfExists(T object) throws ConditionalCheckFailedException {
        DynamoDBDeleteExpression deleteExpression = new DynamoDBDeleteExpression();
        for (DynamoDBMapperFieldModel<T, Object> key : this.model.keys()) {
            deleteExpression.withExpectedEntry(key.name(), new ExpectedAttributeValue().withExists(true).withValue((AttributeValue)key.convert(key.get(object))));
        }
        this.mapper.delete(object, deleteExpression);
    }

    public int count(DynamoDBQueryExpression<T> queryExpression) {
        return this.mapper.count(this.model.targetType(), queryExpression);
    }

    public PaginatedQueryList<T> query(DynamoDBQueryExpression<T> queryExpression) {
        return this.mapper.query(this.model.targetType(), queryExpression);
    }

    public QueryResultPage<T> queryPage(DynamoDBQueryExpression<T> queryExpression) {
        return this.mapper.queryPage(this.model.targetType(), queryExpression);
    }

    public int count(DynamoDBScanExpression scanExpression) {
        return this.mapper.count(this.model.targetType(), scanExpression);
    }

    public PaginatedScanList<T> scan(DynamoDBScanExpression scanExpression) {
        return this.mapper.scan(this.model.targetType(), scanExpression);
    }

    public ScanResultPage<T> scanPage(DynamoDBScanExpression scanExpression) {
        return this.mapper.scanPage(this.model.targetType(), scanExpression);
    }

    public PaginatedParallelScanList<T> parallelScan(DynamoDBScanExpression scanExpression, int totalSegments) {
        return this.mapper.parallelScan(this.model.targetType(), scanExpression, totalSegments);
    }

    public TableDescription describeTable() {
        return this.db.describeTable(this.mapper.getTableName(this.model.targetType(), this.config)).getTable();
    }

    public TableDescription createTable(ProvisionedThroughput throughput) {
        CreateTableRequest request = this.mapper.generateCreateTableRequest(this.model.targetType());
        request.setProvisionedThroughput(throughput);
        if (request.getGlobalSecondaryIndexes() != null) {
            for (GlobalSecondaryIndex gsi : request.getGlobalSecondaryIndexes()) {
                gsi.setProvisionedThroughput(throughput);
            }
        }
        return this.db.createTable(request).getTableDescription();
    }

    public boolean createTableIfNotExists(ProvisionedThroughput throughput) {
        try {
            this.createTable(throughput);
        }
        catch (ResourceInUseException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Table already exists, no need to create", e);
            }
            return false;
        }
        return true;
    }

    public TableDescription deleteTable() {
        return this.db.deleteTable(this.mapper.generateDeleteTableRequest(this.model.targetType())).getTableDescription();
    }

    public boolean deleteTableIfExists() {
        try {
            this.deleteTable();
        }
        catch (ResourceNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Table does not exist, no need to delete", e);
            }
            return false;
        }
        return true;
    }
}

