/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class StatisticSetStaxUnmarshaller
implements Unmarshaller<StatisticSet, StaxUnmarshallerContext> {
    private static StatisticSetStaxUnmarshaller instance;

    @Override
    public StatisticSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        StatisticSet statisticSet = new StatisticSet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return statisticSet;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SampleCount", targetDepth)) {
                    statisticSet.setSampleCount(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Sum", targetDepth)) {
                    statisticSet.setSum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Minimum", targetDepth)) {
                    statisticSet.setMinimum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Maximum", targetDepth)) continue;
                statisticSet.setMaximum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return statisticSet;
    }

    public static StatisticSetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StatisticSetStaxUnmarshaller();
        }
        return instance;
    }
}

