/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonServiceException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.ResourceNotFoundException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

public class ResourceNotFoundExceptionUnmarshaller
extends StandardErrorUnmarshaller {
    public ResourceNotFoundExceptionUnmarshaller() {
        super(ResourceNotFoundException.class);
    }

    @Override
    public AmazonServiceException unmarshall(Node node) throws Exception {
        String errorCode = this.parseErrorCode(node);
        if (errorCode == null || !errorCode.equals("ResourceNotFoundException")) {
            return null;
        }
        ResourceNotFoundException e = (ResourceNotFoundException)super.unmarshall(node);
        e.setResourceType(XpathUtils.asString(this.getErrorPropertyPath("ResourceType"), node));
        e.setResourceId(XpathUtils.asString(this.getErrorPropertyPath("ResourceId"), node));
        return e;
    }
}

