/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n2;

import com.amazon.ws.emr.hadoop.fs.consistency.ConsistencyCheckerS3FileSystem;
import com.amazon.ws.emr.hadoop.fs.consistency.ConsistencyExceptionThrowableObjectMetadataRetrieverImpl;
import com.amazon.ws.emr.hadoop.fs.consistency.exception.ConsistencyException;
import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.maintenance.MultipartUploadCleaner;
import com.amazon.ws.emr.hadoop.fs.notification.NotificationDispatcher;
import com.amazon.ws.emr.hadoop.fs.notification.Notifier;
import com.amazon.ws.emr.hadoop.fs.property.RetryPolicyType;
import com.amazon.ws.emr.hadoop.fs.s3.S3NativeCommonFileSystem;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.ConsistencyExceptionThrowableObjectMetadataRetriever;
import com.amazon.ws.emr.hadoop.fs.s3n2.S3FileSystem;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Maps;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Inject;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import com.amazon.ws.emr.hadoop.fs.util.io.MoreCloseables;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.staging.StagingDirectoryService;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3NativeFileSystem2
extends S3NativeCommonFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(S3NativeFileSystem2.class);
    private boolean initialized = false;
    private String serverSideEncryptionAlgorithm = null;
    private URI uri;
    private String bucket;
    private Path workingDirectory;
    private S3FileSystem s3FileSystem;
    private boolean throwOnInconsistency;
    @Inject
    private EntityStore<Entity> entityStore;
    @Inject
    private AmazonS3Lite s3;
    @Inject
    private ListeningExecutorService listeningExecutorService;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    @Inject
    private MultipartUploadCleaner multipartUploadCleaner;
    @Inject
    private FileSystemOwner fileSystemOwner;

    public void close() throws IOException {
        LOG.debug("Closing for bucket {}", (Object)this.bucket);
        LOG.debug("Shutting down thread pool executor");
        Closeable[] closeableArray = new Closeable[2];
        closeableArray[0] = this.s3FileSystem;
        closeableArray[1] = this.listeningExecutorService::shutdown;
        MoreCloseables.closeAll(closeableArray);
        LOG.debug("Done closing for bucket {}", (Object)this.bucket);
    }

    public void initialize(URI uri, Configuration configuration) throws IOException {
        Preconditions.checkArgument(!this.initialized, "{} has already initialized", ((Object)((Object)this)).getClass().getName());
        this.initialized = true;
        super.initialize(uri, configuration);
        this.setConf(configuration);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        LOG.debug("URI is {}", (Object)this.uri);
        this.bucket = EmrFsUtils.pathToBucket(new Path(this.uri));
        this.setWorkingDirectory(new Path("/user", this.fileSystemOwner.getFullUserName()).makeQualified(uri, this.getWorkingDirectory()));
        this.s3FileSystem = this.createConsistencyCheckerFileSystem(configuration);
        LOG.debug("Setting working directory to '{}'", (Object)this.getWorkingDirectory());
        this.ensureBucketExists();
        if (ConfigurationUtils.isServerSideEncryptionEnabled(configuration)) {
            this.serverSideEncryptionAlgorithm = ConfigurationUtils.getServerSideEncryptionAlgorithm(configuration);
        }
        this.throwOnInconsistency = ConfigurationUtils.isThrowingExceptionOnInconsistencyEnabled(configuration);
        this.multipartUploadCleaner.scheduleMultipartCleanup(this.bucket);
    }

    public URI getUri() {
        return this.uri;
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.open(path, bufferSize, this.throwOnInconsistency);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Open, path, e.getPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.create(path, overwrite, progress, this.statistics);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Create, path, e.getPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            throw new IOException("Cannot create file due to inconsistency: " + path, e);
        }
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        LOG.info("rename {} {}", (Object)src.toString(), (Object)dst.toString());
        this.checkNotStagingDirectoryPath(src);
        this.checkNotStagingDirectoryPath(dst);
        this.multipartUploadCleaner.scheduleMultipartCleanup(src);
        this.multipartUploadCleaner.scheduleMultipartCleanup(dst);
        try {
            return this.s3FileSystem.rename(src, dst, true);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Rename, src, dst, e.getPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            return this.s3FileSystem.rename(src, dst, false);
        }
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.delete(path, recursive, true);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Delete, path, e.getPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            return this.s3FileSystem.delete(path, recursive, false);
        }
    }

    public boolean deleteOnExit(Path path) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        return super.deleteOnExit(path);
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDirectory = newDir;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            this.s3FileSystem.mkdirs(path);
            return true;
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Mkdirs, path, e.getPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            throw new IOException("Cannot create directory due to inconsistency: " + path, e);
        }
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.listStatus(path, true);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.ListStatus, path, e.getPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            try {
                return this.s3FileSystem.listStatus(path, false);
            }
            catch (AmazonClientException ace) {
                throw new IOException(ace);
            }
        }
        catch (AmazonClientException ace) {
            throw new IOException(ace);
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.getFileStatus(path);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.GetFileStatus, path, e.getPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new FileNotFoundException(e.getMessage());
        }
        catch (AmazonClientException ace) {
            throw new IOException(ace);
        }
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (start < 0L || len < 0L) {
            throw new IllegalArgumentException("Invalid start or len parameter");
        }
        if (file.getLen() < start) {
            return new BlockLocation[0];
        }
        String[] name = new String[]{"localhost:50010"};
        String[] host = new String[]{"*"};
        long length = file.getLen();
        long blockSize = this.getDefaultBlockSize();
        ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>((int)(length / blockSize + 1L));
        long i = 0L;
        while (length > 0L) {
            long blockLength;
            if ((length -= (blockLength = Math.min(blockSize, length))) < blockSize) {
                blockLength += length;
                length = 0L;
            }
            locations.add(new BlockLocation(name, host, blockSize * i, blockLength));
            LOG.debug("Adding block at " + blockSize * i + " with length " + blockLength);
            ++i;
        }
        return locations.toArray(new BlockLocation[0]);
    }

    public long getDefaultBlockSize() {
        return ConfigurationUtils.getBlockSize(this.getConf());
    }

    public long getDefaultBlockSize(Path path) {
        return this.getDefaultBlockSize();
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        Path absolutePath = EmrFsUtils.makeAbsolute(this.workingDirectory, path);
        String key = EmrFsUtils.pathToKey(absolutePath);
        if (key.length() != 0) {
            Path parent = absolutePath.getParent();
            if (!this.exists(parent)) {
                throw new FileNotFoundException(String.format("Unable to create '%s': parent '%s' was not found.", absolutePath, parent));
            }
            if (!this.isDirectory(parent)) {
                throw new IOException(String.format("Unable to create '%s': parent '%s' is not a directory.", absolutePath, parent));
            }
        }
        return this.create(absolutePath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataInputStream select(Path path, Configuration selectOptions, int bufferSize) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.select(path, selectOptions, bufferSize, this.throwOnInconsistency);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Open, path, e.getPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public StagingDirectoryService getStagingDirectoryService() {
        return this.s3FileSystem.getStagingDirectoryService();
    }

    private void ensureBucketExists() {
        if (ConfigurationUtils.isCreateBucketEnabled(this.getConf())) {
            LOG.debug("Validating that bucket '{}' exists", (Object)this.bucket);
            String bucketsCreateRegion = ConfigurationUtils.getBucketsCreateRegion(this.getConf());
            if (!this.s3.doesBucketExist(this.bucket)) {
                this.s3.createBucket(this.bucket, bucketsCreateRegion);
            }
        }
    }

    private S3FileSystem createConsistencyCheckerFileSystem(Configuration configuration) {
        RetryPolicy retryPolicy = this.createConsistentExceptionRetryPolicy();
        ConsistencyExceptionThrowableObjectMetadataRetriever objectMetadataRetriever = (ConsistencyExceptionThrowableObjectMetadataRetriever)RetryProxy.create(ConsistencyExceptionThrowableObjectMetadataRetriever.class, (Object)new ConsistencyExceptionThrowableObjectMetadataRetrieverImpl(this.s3), (RetryPolicy)retryPolicy);
        ConsistencyCheckerS3FileSystem fileSystem = new ConsistencyCheckerS3FileSystem(this.s3, this.entityStore, this.listeningExecutorService, configuration, this.getUri(), this.getWorkingDirectory(), this.getDefaultBlockSize(), this.fileSystemOwner, objectMetadataRetriever);
        return (S3FileSystem)RetryProxy.create(S3FileSystem.class, (Object)fileSystem, (RetryPolicy)retryPolicy);
    }

    @VisibleForTesting
    public RetryPolicy createConsistentExceptionRetryPolicy() {
        RetryPolicyType retryPolicyType = ConfigurationUtils.getRetryPolicyType(this.getConf());
        int retryPeriodSeconds = ConfigurationUtils.getConsistencyRetryPeriodSeconds(this.getConf());
        int retryCount = ConfigurationUtils.getConsistencyRetryCount(this.getConf());
        RetryPolicy consistencyPolicy = null;
        switch (retryPolicyType) {
            case EXPONENTIAL: 
            case FAST_FIRST_RETRY_EXPONENTIAL: {
                consistencyPolicy = RetryPolicies.exponentialBackoffRetry((int)retryCount, (long)retryPeriodSeconds, (TimeUnit)TimeUnit.SECONDS);
                break;
            }
            case FIXED: 
            case FAST_FIRST_RETRY_FIXED: {
                consistencyPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)retryCount, (long)retryPeriodSeconds, (TimeUnit)TimeUnit.SECONDS);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new RuntimeException("unknown retry policy type: " + (Object)((Object)retryPolicyType));
            }
        }
        HashMap<Class<ConsistencyException>, RetryPolicy> policyMap = Maps.newHashMap();
        policyMap.put(ConsistencyException.class, consistencyPolicy);
        return RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, policyMap);
    }

    private Path getAbsolutePath(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.getWorkingDirectory(), path);
    }
}

