/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.EmrFSFutureCallback;
import com.amazon.ws.emr.hadoop.fs.cse.CSEMultipartUploadOutputStream;
import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectories;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectoriesGenerator;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryFiles;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.maintenance.MultipartUploadCleaner;
import com.amazon.ws.emr.hadoop.fs.s3.AbstractS3FSInputStream;
import com.amazon.ws.emr.hadoop.fs.s3.FileCreationSubsystem;
import com.amazon.ws.emr.hadoop.fs.s3.FileCreationSubsystemFactory;
import com.amazon.ws.emr.hadoop.fs.s3.InputStreamWithInfo;
import com.amazon.ws.emr.hadoop.fs.s3.S3NativeCommonFileSystem;
import com.amazon.ws.emr.hadoop.fs.s3.S3ObjectRequestFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3EncryptionLite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.AfterUploadCompletionObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.PreviousInstructionFileDeleter;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UnencryptedLengthHeaderAdder;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.RegularUploadPlannerFactory;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadConstraint;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanner;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlannerFactory;
import com.amazon.ws.emr.hadoop.fs.s3n.BasicFileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import com.amazon.ws.emr.hadoop.fs.s3n.FileStatusCache;
import com.amazon.ws.emr.hadoop.fs.s3n.FileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.s3n.Jets3tNativeFileSystemStore;
import com.amazon.ws.emr.hadoop.fs.s3n.MultipartUploadOutputStream;
import com.amazon.ws.emr.hadoop.fs.s3n.NativeFileSystemStore;
import com.amazon.ws.emr.hadoop.fs.s3n.PartialListing;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Sets;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Inject;
import com.amazon.ws.emr.hadoop.fs.staging.StagingMechanism;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import com.amazon.ws.emr.hadoop.fs.util.ExceptionCollector;
import com.amazon.ws.emr.hadoop.fs.util.RetryUtils;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.common.Abortable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.staging.StagingDirectoryService;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3NativeFileSystem
extends S3NativeCommonFileSystem {
    public static final Logger LOG = LoggerFactory.getLogger(S3NativeFileSystem.class);
    public static final String FOLDER_SUFFIX = "_$folder$";
    static final String PATH_DELIMITER = "/";
    private String serverSideEncryptionAlgorithm = null;
    private String serverSideEncryptionKmsKeyId = null;
    private static final int S3_LIST_MAX_KEYS = 1000;
    private static final int S3_LIST_MIN_KEYS = 1;
    private boolean lazyInitializeS3Connection = false;
    @VisibleForTesting
    static final int NUM_READ_RETRIES = 5;
    @Inject
    private ListeningExecutorService exec;
    @Inject
    private AmazonS3Lite s3;
    @Inject
    private FileSystemOwner fileSystemOwner;
    @Inject
    private MultipartUploadCleaner multipartUploadCleaner;
    private FileStatusFactory fileStatusFactory;
    private FileCreationSubsystem fileCreationSubsystem;
    private Set<org.apache.hadoop.fs.Path> deleteOnExit = new TreeSet<org.apache.hadoop.fs.Path>();
    private static ThreadLocal<FileStatusCache> cachedFileStatus = new ThreadLocal<FileStatusCache>(){

        @Override
        protected FileStatusCache initialValue() {
            LOG.info("Creating cachedFileStatus initial object");
            return new FileStatusCache();
        }
    };
    private static ThreadLocal<Boolean> useCache = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private URI uri;
    protected NativeFileSystemStore store;
    private org.apache.hadoop.fs.Path workingDirectory;
    private TemporaryDirectoriesGenerator temporaryDirectoriesGenerator;

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (start < 0L || len < 0L) {
            throw new IllegalArgumentException("Invalid start or len parameter");
        }
        if (file.getLen() < start) {
            return new BlockLocation[0];
        }
        String[] name = new String[]{"localhost:50010"};
        String[] host = new String[]{"*"};
        long length = file.getLen();
        long blockSize = this.getDefaultBlockSize();
        ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>((int)(length / blockSize + 1L));
        long i = 0L;
        while (length > 0L) {
            long blockLength;
            if ((length -= (blockLength = Math.min(blockSize, length))) < blockSize) {
                blockLength += length;
                length = 0L;
            }
            locations.add(new BlockLocation(name, host, blockSize * i, blockLength));
            LOG.debug("Adding block at " + blockSize * i + " with length " + blockLength);
            ++i;
        }
        return locations.toArray(new BlockLocation[0]);
    }

    @Inject
    public S3NativeFileSystem() {
    }

    @VisibleForTesting
    S3NativeFileSystem(NativeFileSystemStore store, MultipartUploadCleaner multipartUploadCleaner) {
        this.store = store;
        this.multipartUploadCleaner = multipartUploadCleaner;
    }

    public void close() throws IOException {
        ExceptionCollector collector = new ExceptionCollector();
        try {
            this.closeFileCreationSubsystem(collector);
            if (this.exec != null) {
                this.exec.shutdown();
            }
            super.close();
        }
        catch (IOException | RuntimeException e) {
            collector.add(e);
        }
        finally {
            collector.rethrowIfNotEmpty(IOException.class);
        }
    }

    private void closeFileCreationSubsystem(ExceptionCollector collector) {
        if (this.fileCreationSubsystem == null) {
            return;
        }
        try {
            this.fileCreationSubsystem.close();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Failed to close the file system ({}) staging mechanism", (Object)this.uri, (Object)e);
            collector.add(e);
        }
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        if (ConfigurationUtils.isServerSideEncryptionEnabled(conf)) {
            this.serverSideEncryptionAlgorithm = ConfigurationUtils.getServerSideEncryptionAlgorithm(conf);
            this.serverSideEncryptionKmsKeyId = ConfigurationUtils.getServerSideEncryptionKmsKeyId(conf);
        }
        if (this.store == null) {
            this.store = new Jets3tNativeFileSystemStore(this.s3, this.exec);
        }
        if (conf.getBoolean("fs.s3n.filestatuscache.enable", false)) {
            S3NativeFileSystem.enableCache();
            cachedFileStatus.get().clearCache();
        }
        this.store.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDirectory = new org.apache.hadoop.fs.Path("/user", this.fileSystemOwner.getFullUserName()).makeQualified(this.getUri(), this.getWorkingDirectory());
        List<Path> tempPaths = ConfigurationUtils.getTestedTempPaths(conf);
        this.temporaryDirectoriesGenerator = new TemporaryDirectoriesGenerator(tempPaths);
        this.multipartUploadCleaner.scheduleMultipartCleanup(uri);
        this.fileStatusFactory = this.newFileStatusFactory();
        this.fileCreationSubsystem = this.newFileCreationSubsystem(uri, conf);
        this.lazyInitializeS3Connection = ConfigurationUtils.getLazyInitializeConnection(conf);
    }

    private BasicFileStatusFactory newFileStatusFactory() {
        return BasicFileStatusFactory.builder().fileSystemOwner(this.fileSystemOwner).pathQualifier(arg_0 -> ((S3NativeFileSystem)this).makeQualified(arg_0)).blockSizeSupplier(this::getDefaultBlockSize).build();
    }

    private FileCreationSubsystem newFileCreationSubsystem(URI uri, Configuration conf) {
        FileCreationSubsystemFactory factory = FileCreationSubsystemFactory.builder().uri(uri).conf(conf).s3(this.s3).requestFactory(new S3ObjectRequestFactory(conf, this.serverSideEncryptionKmsKeyId)).uploadObserver(this.newUploadObserver()).nonStagingPlannerFactory(this.newNonStagingPlannerFactory()).pathQualifier(arg_0 -> ((S3NativeFileSystem)this).makeQualified(arg_0)).fileStatusFactory(this.fileStatusFactory).build();
        return factory.create();
    }

    private UploadObserver newUploadObserver() {
        PreviousInstructionFileDeleter instructionFileDeleter = new PreviousInstructionFileDeleter(this.s3, this.getConf());
        ArrayList<UploadObserver> observers = Lists.newArrayList(instructionFileDeleter);
        if (ConfigurationUtils.isClientSideEncryptionEnabled(this.getConf())) {
            observers.add(new UnencryptedLengthHeaderAdder(this.s3, this.getConf()));
        }
        observers.add(new CacheInvalidator());
        return UploadObserver.chain(observers);
    }

    private UploadPlannerFactory newNonStagingPlannerFactory() {
        return new RegularUploadPlannerFactory(arg_0 -> ((S3NativeFileSystem)this).exists(arg_0));
    }

    private String pathToKey(org.apache.hadoop.fs.Path path) {
        return EmrFsUtils.pathToKey(path);
    }

    private static org.apache.hadoop.fs.Path keyToPath(String key) {
        return new org.apache.hadoop.fs.Path(PATH_DELIMITER + key);
    }

    private org.apache.hadoop.fs.Path makeAbsolute(org.apache.hadoop.fs.Path path) {
        return EmrFsUtils.makeAbsolute(this.workingDirectory, path);
    }

    public FSDataOutputStream append(org.apache.hadoop.fs.Path path, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(absolutePath);
        UploadPlan uploadPlan = this.getUploadPlanner().plan(absolutePath, overwrite);
        String key = uploadPlan.getKey();
        this.store.invalidateCache(key);
        LOG.debug("Creating new file '{}://{}/{}' in S3", new Object[]{this.uri.getScheme(), uploadPlan.getBucket(), key});
        this.clearCache(key);
        Configuration conf = this.getConf();
        boolean cseEnabled = ConfigurationUtils.isClientSideEncryptionEnabled(this.getConf());
        OutputStream outputStream = uploadPlan.getConstraint() != UploadConstraint.SINGLE_PART_UPLOAD ? (!cseEnabled ? new MultipartUploadOutputStream(this.s3, conf, this.store, this.exec, progress, uploadPlan, this.serverSideEncryptionAlgorithm, this.serverSideEncryptionKmsKeyId, this.temporaryDirectoriesGenerator.createTemporaryDirectories()) : new CSEMultipartUploadOutputStream((AmazonS3EncryptionLite)this.s3, uploadPlan, this.getConf(), progress, this.exec, this.temporaryDirectoriesGenerator.createTemporaryDirectory())) : new NativeS3FsOutputStream(conf, this.store, key, progress, this.temporaryDirectoriesGenerator.createTemporaryDirectory());
        return new FSDataOutputStream(outputStream, this.statistics);
    }

    @Deprecated
    public boolean delete(org.apache.hadoop.fs.Path path) throws IOException {
        return this.delete(path, true);
    }

    public boolean delete(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        FileStatus status;
        LOG.debug("Delete called for {}", (Object)path);
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            status = this.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Delete called for '" + path + "' but file does not exist, so returning false");
            }
            return false;
        }
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String key = this.pathToKey(absolutePath);
        this.clearCache(key);
        if (status.isDirectory()) {
            List<String> keysToDelete = this.listAllKeys(path);
            if (!recursive && keysToDelete.size() > 0) {
                throw new IOException("Can not delete " + path + " at is a not empty directory and recurse option is false");
            }
            this.createParent(path);
            LOG.debug("Deleting directory {}", (Object)path);
            try {
                this.doSingleThreadedBatchDelete(keysToDelete);
            }
            catch (IOException ie) {
                throw new IOException("Failed to delete key: " + key, ie);
            }
            try {
                this.store.delete(key + FOLDER_SUFFIX);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting file '" + path + "'");
            }
            this.createParent(path);
            this.store.delete(key);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteOnExit(org.apache.hadoop.fs.Path path) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        if (!this.exists(path)) {
            return false;
        }
        Set<org.apache.hadoop.fs.Path> set = this.deleteOnExit;
        synchronized (set) {
            this.deleteOnExit.add(path);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelDeleteOnExit(org.apache.hadoop.fs.Path path) {
        Set<org.apache.hadoop.fs.Path> set = this.deleteOnExit;
        synchronized (set) {
            return this.deleteOnExit.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeleteOnExit() {
        Set<org.apache.hadoop.fs.Path> set = this.deleteOnExit;
        synchronized (set) {
            ArrayList<String> keysToDelete = new ArrayList<String>();
            for (org.apache.hadoop.fs.Path f : this.deleteOnExit) {
                try {
                    if (!this.exists(f)) continue;
                    if (this.isDirectory(f)) {
                        this.delete(f, true);
                        continue;
                    }
                    keysToDelete.add(this.pathToKey(this.makeAbsolute(f)));
                }
                catch (IOException e) {
                    LOG.info("Ignoring failure in batch deleteOnExit", (Throwable)e);
                }
            }
            if (!keysToDelete.isEmpty()) {
                try {
                    this.doSingleThreadedBatchDelete(keysToDelete);
                }
                catch (IOException e) {
                    LOG.info("Ignoring failure in batch deleteOnExit", (Throwable)e);
                }
            }
            this.deleteOnExit.clear();
        }
    }

    public FileStatus getFileStatus(org.apache.hadoop.fs.Path path) throws IOException {
        PartialListing listing;
        FileMetadata meta;
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(absolutePath);
        if (this.getStagingMechanism().isStagingDirectoryPath(path)) {
            return this.getStagingMechanism().getFileStatus(path);
        }
        String key = this.pathToKey(absolutePath);
        if (key.length() == 0) {
            return this.newDirectory(absolutePath);
        }
        FileStatus keyStatus = this.getKeyFromCache(absolutePath);
        if (keyStatus != null) {
            return keyStatus;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatus retrieving metadata for key '" + key + "'");
        }
        if ((meta = this.store.retrieveMetadata(key)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileStatus returning 'file' for key '" + key + "'");
            }
            return this.newFile(meta, absolutePath, false);
        }
        if (this.store.retrieveMetadata(key + FOLDER_SUFFIX) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileStatus returning 'directory' for key '" + key + "' as '" + key + FOLDER_SUFFIX + "' exists");
            }
            return this.newDirectory(absolutePath);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatus listing key '" + key + "'");
        }
        String continuationToken = null;
        int keysCount = 0;
        HashSet<String> listingDirs = Sets.newHashSetWithExpectedSize(1);
        do {
            listing = this.store.list(key, 1, null, continuationToken, false);
            listingDirs.addAll(listing.getDirs());
        } while ((continuationToken = listing.getNextContinuationToken()) != null && (keysCount += listing.getFiles().size()) == 0 && listingDirs.isEmpty());
        if (keysCount > 0 || !listingDirs.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileStatus returning 'directory' for key '" + key + "' as it has contents ");
            }
            if (this.getConf().getBoolean("fs.s3.folderObject.autoInsert", false)) {
                String folderKey = key + FOLDER_SUFFIX;
                LOG.debug("getFileStatus creating '" + folderKey + "' as key '" + key + "' exists as a folder ");
                try {
                    this.store.storeEmptyFile(folderKey);
                }
                catch (Exception e) {
                    LOG.debug("getFileStatus cannot insert '" + folderKey + "'", (Throwable)e);
                }
            }
            return this.newDirectory(absolutePath);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatus could not find key '" + key + "'");
        }
        throw new FileNotFoundException("No such file or directory '" + absolutePath + "'");
    }

    private FileStatus getKeyFromCache(org.apache.hadoop.fs.Path absolutePath) throws IOException {
        String key = this.pathToKey(absolutePath);
        if (useCache.get().booleanValue()) {
            this.verifyCache(key);
            return cachedFileStatus.get().getFileStatus(key, this);
        }
        return null;
    }

    private void verifyCache(String key) throws IOException {
        if (!cachedFileStatus.get().isCached(key)) {
            this.cache(key);
        }
    }

    public URI getUri() {
        return this.uri;
    }

    private List<String> listAllKeys(org.apache.hadoop.fs.Path path) throws IOException {
        PartialListing listing;
        ArrayList<String> allKeys = new ArrayList<String>();
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String key = this.pathToKey(absolutePath);
        String continuationToken = null;
        do {
            listing = this.store.list(key, 1000, null, continuationToken, true);
            List<FileMetadata> files = listing.getFiles();
            allKeys.ensureCapacity(allKeys.size() + files.size());
            for (FileMetadata fileMetadata : files) {
                allKeys.add(fileMetadata.getKey());
            }
        } while ((continuationToken = listing.getNextContinuationToken()) != null);
        return allKeys;
    }

    public org.apache.hadoop.fs.Path[] getEmptySubDirPaths(org.apache.hadoop.fs.Path parent) throws IOException {
        PartialListing listing;
        this.checkNotStagingDirectoryPath(parent);
        HashSet<org.apache.hadoop.fs.Path> emptySubDirs = new HashSet<org.apache.hadoop.fs.Path>();
        HashSet<org.apache.hadoop.fs.Path> visitedNonEmptyPaths = new HashSet<org.apache.hadoop.fs.Path>();
        String key = this.pathToKey(parent);
        String continuationToken = null;
        URI pathUri = parent.toUri();
        do {
            org.apache.hadoop.fs.Path subDirPath;
            String relativePath;
            listing = this.store.list(key, 1000, null, continuationToken, false);
            for (String commonPrefix : listing.getCommonPrefixes()) {
                org.apache.hadoop.fs.Path subPath = S3NativeFileSystem.keyToPath(commonPrefix);
                relativePath = pathUri.relativize(subPath.toUri()).getPath();
                subDirPath = new org.apache.hadoop.fs.Path(parent, relativePath);
                visitedNonEmptyPaths.add(subDirPath);
            }
            for (FileMetadata fileMetadata : listing.getFiles()) {
                org.apache.hadoop.fs.Path subpath = S3NativeFileSystem.keyToPath(fileMetadata.getKey());
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                if (fileMetadata.getKey().equals(key + PATH_DELIMITER) || !relativePath.endsWith(FOLDER_SUFFIX)) continue;
                subDirPath = new org.apache.hadoop.fs.Path(parent, relativePath.substring(0, relativePath.indexOf(FOLDER_SUFFIX)));
                if (!visitedNonEmptyPaths.contains(subDirPath)) {
                    emptySubDirs.add(subDirPath);
                    continue;
                }
                visitedNonEmptyPaths.remove(subDirPath);
            }
        } while ((continuationToken = listing.getNextContinuationToken()) != null);
        return emptySubDirs.toArray(new org.apache.hadoop.fs.Path[emptySubDirs.size()]);
    }

    public FileStatus[] listStatus(org.apache.hadoop.fs.Path path) throws IOException {
        return this.listStatus(path, false);
    }

    public FileStatus[] listStatus(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        PartialListing listing;
        FileMetadata meta;
        LOG.debug("listStatus {} with recursive {}", (Object)path.toString(), (Object)recursive);
        this.checkNotStagingDirectoryPath(path);
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(absolutePath);
        String key = this.pathToKey(absolutePath);
        List<FileStatus> keyStatus = this.listFromCache(absolutePath);
        if (keyStatus != null) {
            return keyStatus.toArray(new FileStatus[keyStatus.size()]);
        }
        if (key.length() > 0 && (meta = this.store.retrieveMetadata(key)) != null) {
            return new FileStatus[]{this.newFile(meta, absolutePath, false)};
        }
        URI pathUri = absolutePath.toUri();
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        String continuationToken = null;
        do {
            String relativePath;
            org.apache.hadoop.fs.Path subpath;
            listing = this.store.list(key, 1000, null, continuationToken, recursive);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                subpath = S3NativeFileSystem.keyToPath(fileMetadata.getKey());
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                String fileMetadataKey = fileMetadata.getKey();
                if (fileMetadataKey.equals(key + PATH_DELIMITER)) continue;
                if (relativePath.endsWith(FOLDER_SUFFIX)) {
                    status.add(this.newDirectory(new org.apache.hadoop.fs.Path(absolutePath, relativePath.substring(0, relativePath.indexOf(FOLDER_SUFFIX)))));
                    continue;
                }
                if (fileMetadataKey.endsWith(PATH_DELIMITER)) {
                    if (!recursive) continue;
                    status.add(this.newDirectory(new org.apache.hadoop.fs.Path(absolutePath, relativePath)));
                    continue;
                }
                status.add(this.newFile(fileMetadata, subpath, true));
            }
            for (String commonPrefix : listing.getCommonPrefixes()) {
                subpath = S3NativeFileSystem.keyToPath(commonPrefix);
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                status.add(this.newDirectory(new org.apache.hadoop.fs.Path(absolutePath, relativePath)));
            }
        } while ((continuationToken = listing.getNextContinuationToken()) != null);
        if (status.isEmpty() && key.length() > 0 && this.store.retrieveMetadata(key + FOLDER_SUFFIX) == null && this.store.retrieveMetadata(key + PATH_DELIMITER) == null) {
            throw new FileNotFoundException("File " + path + " does not exist.");
        }
        return status.toArray(new FileStatus[status.size()]);
    }

    private List<FileStatus> listFromCache(org.apache.hadoop.fs.Path absolutePath) throws IOException {
        String key = this.pathToKey(absolutePath);
        if (useCache.get().booleanValue()) {
            this.verifyCache(key);
            return cachedFileStatus.get().listStatus(key);
        }
        return null;
    }

    private TreeMap<String, FileStatus> fetchKeysFromStore(String prefix, String startAfter, Integer maxKeys) throws IOException {
        FileMetadata meta;
        TreeMap<String, FileStatus> prefetchMap = new TreeMap<String, FileStatus>();
        int numListedKeys = 0;
        if (startAfter != null && !startAfter.isEmpty() && (meta = this.store.retrieveMetadata(startAfter)) != null) {
            prefetchMap.put(startAfter, this.newFile(meta, S3NativeFileSystem.keyToPath(meta.getKey()), false));
            ++numListedKeys;
        }
        int numKeysToList = this.getNumKeysToList(maxKeys, numListedKeys);
        String previousKey = null;
        String continuationToken = null;
        while (numKeysToList > 0) {
            PartialListing listing = this.store.list(prefix, numKeysToList, startAfter, continuationToken, true);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                String relativeKey;
                org.apache.hadoop.fs.Path subpath = S3NativeFileSystem.keyToPath(fileMetadata.getKey());
                String currentKey = fileMetadata.getKey();
                this.checkClosedFolders(previousKey, currentKey, prefetchMap);
                previousKey = currentKey;
                if (currentKey.endsWith(FOLDER_SUFFIX)) {
                    relativeKey = currentKey.substring(0, currentKey.indexOf(FOLDER_SUFFIX));
                    this.insertDirectory(relativeKey, prefetchMap);
                    continue;
                }
                if (currentKey.endsWith(PATH_DELIMITER)) {
                    relativeKey = currentKey.substring(0, currentKey.length() - 1);
                    this.insertDirectory(relativeKey, prefetchMap);
                    continue;
                }
                prefetchMap.put(currentKey, this.newFile(fileMetadata, subpath, true));
            }
            continuationToken = listing.getNextContinuationToken();
            if (startAfter == null) break;
            numKeysToList = this.getNumKeysToList(maxKeys, numListedKeys += numKeysToList);
        }
        return prefetchMap;
    }

    private void insertDirectory(String key, TreeMap<String, FileStatus> prefetchMap) {
        if (prefetchMap.isEmpty() || prefetchMap.firstKey().compareTo(key) < 0) {
            prefetchMap.put(key, this.newDirectory(S3NativeFileSystem.keyToPath(key).makeQualified(this.getUri(), this.getWorkingDirectory())));
        }
    }

    private int getNumKeysToList(Integer maxKeys, int numListed) {
        if (maxKeys != null) {
            int remaining = maxKeys - numListed;
            if (remaining > 1000) {
                return 1000;
            }
            return remaining > 0 ? remaining : 0;
        }
        return 1000;
    }

    private void checkClosedFolders(String previousKey, String currentKey, TreeMap<String, FileStatus> prefetchMap) {
        if (previousKey == null || !previousKey.contains(PATH_DELIMITER)) {
            return;
        }
        String[] previousFolders = previousKey.split(PATH_DELIMITER);
        String[] newFolders = currentKey.split(PATH_DELIMITER);
        String currentPath = "";
        boolean differ = false;
        for (int i = 0; i < previousFolders.length - 1; ++i) {
            currentPath = currentPath + previousFolders[i];
            if (differ || newFolders.length <= i || !previousFolders[i].equals(newFolders[i])) {
                differ = true;
                this.insertDirectory(currentPath, prefetchMap);
            }
            currentPath = currentPath + PATH_DELIMITER;
        }
    }

    private void cache(String key) throws IOException {
        TreeMap<String, FileStatus> keyMap = this.fetchKeysFromStore("", key, 1000);
        cachedFileStatus.get().buildCache(keyMap, key);
    }

    @Deprecated
    public synchronized void prefetch(org.apache.hadoop.fs.Path path, String marker, Integer maxKeys) throws IOException {
        LOG.info("prefetch cache is deprecated and no-op");
    }

    @Deprecated
    public synchronized void clearPrefetch() {
        LOG.info("prefetch cache is deprecated and no-op");
    }

    public static synchronized void enableCache() {
        LOG.info("Enable FileStatusCache for contiguous s3 objects");
        useCache.set(true);
    }

    public static synchronized void disableCache() {
        LOG.info("Disabling FileStatusCache");
        useCache.set(false);
        cachedFileStatus.get().clearCache();
    }

    public static synchronized boolean isCacheEnabled() {
        return useCache.get();
    }

    public static void clearCache() {
        cachedFileStatus.get().clearCache();
    }

    private void clearCache(String key) {
        if (useCache.get().booleanValue()) {
            cachedFileStatus.get().clearKey(key);
        }
    }

    @Deprecated
    public synchronized boolean isPrefetchEnabled() {
        return false;
    }

    private FileStatus newFile(FileMetadata meta, org.apache.hadoop.fs.Path path, boolean lazyLoad) {
        if (lazyLoad && ConfigurationUtils.isClientSideEncryptionEnabled(this.getConf()) && this.getConf().getBoolean("fs.s3.cse.plaintextLength.enabled", true)) {
            return new FileStatus(meta.getLength(), false, 1, this.getDefaultBlockSize(), meta.getLastModified(), 0L, null, this.fileSystemOwner.getFullUserName(), this.fileSystemOwner.getGroup(), path.makeQualified(this.getUri(), this.getWorkingDirectory())){
                private long plaintextLength;
                {
                    this.plaintextLength = -1L;
                }

                public long getLen() {
                    if (this.plaintextLength == -1L) {
                        String bucket = EmrFsUtils.pathToBucket(this.getPath());
                        String key = S3NativeFileSystem.this.pathToKey(this.getPath());
                        this.plaintextLength = CSEUtils.getPlaintextLength(S3NativeFileSystem.this.s3, bucket, key, null, S3NativeFileSystem.this.getConf());
                    }
                    return this.plaintextLength;
                }
            };
        }
        return this.fileStatusFactory.newFile(path, meta.getLength(), meta.getLastModified());
    }

    FileStatus newDirectory(org.apache.hadoop.fs.Path path) {
        return this.fileStatusFactory.newDirectory(path);
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path targetPath, FsPermission permission) throws IOException {
        this.checkNotStagingDirectoryPath(targetPath);
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(targetPath);
        org.apache.hadoop.fs.Path parentPath = null;
        if (absolutePath != null) {
            parentPath = absolutePath.getParent();
        }
        ArrayList<org.apache.hadoop.fs.Path> paths = new ArrayList<org.apache.hadoop.fs.Path>();
        do {
            paths.add(0, absolutePath);
        } while ((parentPath = (absolutePath = parentPath).getParent()) != null);
        boolean result = true;
        for (org.apache.hadoop.fs.Path path : paths) {
            result &= this.mkdir(path);
        }
        return result;
    }

    private boolean mkdir(org.apache.hadoop.fs.Path path) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                throw new IOException(String.format("Can't make directory for path '%s' since it is a file.", path));
            }
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Making dir '" + path + "' in S3");
            }
            String key = this.pathToKey(path) + FOLDER_SUFFIX;
            this.store.storeEmptyFile(key);
        }
        return true;
    }

    public FSDataInputStream open(org.apache.hadoop.fs.Path path, int bufferSize) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        FileStatus fs = this.getFileStatus(path);
        if (fs.isDirectory()) {
            throw new IOException("'" + path + "' is a directory");
        }
        LOG.info("Opening '" + path + "' for reading");
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String key = this.pathToKey(absolutePath);
        InputStreamWithInfo inputStreamWithInfo = this.lazyInitializeS3Connection ? this.store.retrieveClosedInputStreamWithInfo(key) : this.store.retrieveInputStreamWithInfo(key, 0L);
        FSDataInputStream input = new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new NativeS3FsInputStream(inputStreamWithInfo), bufferSize));
        return input;
    }

    private void createParent(org.apache.hadoop.fs.Path path) throws IOException {
        String parentKey;
        org.apache.hadoop.fs.Path parentPath = path.getParent();
        if (parentPath != null && !parentPath.isRoot() && (parentKey = this.pathToKey(this.makeAbsolute(parentPath))).length() > 0 && !this.exists(S3NativeFileSystem.keyToPath(parentKey + FOLDER_SUFFIX))) {
            this.store.storeEmptyFile(parentKey + FOLDER_SUFFIX);
        }
    }

    public boolean rename(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst) throws IOException {
        boolean srcIsFile;
        String dstKey;
        LOG.info("rename {} {}", (Object)src.toString(), (Object)dst.toString());
        this.checkNotStagingDirectoryPath(src);
        this.checkNotStagingDirectoryPath(dst);
        this.multipartUploadCleaner.scheduleMultipartCleanup(src);
        this.multipartUploadCleaner.scheduleMultipartCleanup(dst);
        String srcKey = this.pathToKey(this.makeAbsolute(src));
        if (srcKey.length() == 0) {
            return false;
        }
        String debugPreamble = "Renaming '" + src + "' to '" + dst + "' - ";
        try {
            boolean dstIsFile = this.getFileStatus(dst).isFile();
            if (dstIsFile) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(debugPreamble + "returning false as dst is an already existing file");
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "using dst as output directory");
            }
            dstKey = this.pathToKey(this.makeAbsolute(new org.apache.hadoop.fs.Path(dst, src.getName())));
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "using dst as output destination");
            }
            dstKey = this.pathToKey(this.makeAbsolute(dst));
            try {
                if (this.getFileStatus(dst.getParent()).isFile()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(debugPreamble + "returning false as dst parent exists and is a file ");
                    }
                    return false;
                }
            }
            catch (FileNotFoundException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(debugPreamble + "returning false as dst parent does not exist " + dst.getParent().toString());
                }
                return false;
            }
        }
        this.clearCache(srcKey);
        this.clearCache(dstKey);
        try {
            srcIsFile = this.getFileStatus(src).isFile();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "returning false as src does not exist");
            }
            return false;
        }
        if (srcIsFile) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "src is file, so doing copy then delete in S3");
            }
            this.store.copy(srcKey, dstKey);
            this.store.delete(srcKey);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "src is directory, so copying contents");
            }
            List<String> keysToRename = this.listAllKeys(src);
            this.store.storeEmptyFile(dstKey + FOLDER_SUFFIX);
            this.doMultiThreadedRename(keysToRename, srcKey, dstKey);
            try {
                this.store.delete(srcKey + FOLDER_SUFFIX);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "done");
            }
        }
        return true;
    }

    private <T> void doMultiThreadedRename(List<String> keysToRename, String srcDirKey, String dstDirKey) throws IOException {
        EmrFSFutureCallback<String> emrFsFutureCallback = new EmrFSFutureCallback<String>(true);
        for (String srcFileKey : keysToRename) {
            if (emrFsFutureCallback.isCancelled()) break;
            String dstFileKey = EmrFsUtils.makeDestFileKey(srcDirKey, dstDirKey, srcFileKey);
            LOG.debug("Src key {} to Dst Key {} DSTKEY {}", new Object[]{srcFileKey, dstFileKey, dstDirKey});
            for (Callable<String> callable : this.store.createCopyCallables(srcFileKey, dstFileKey)) {
                emrFsFutureCallback.registerFuture(this.exec.submit(callable));
            }
        }
        try {
            emrFsFutureCallback.ensureFuturesComplete();
        }
        catch (RuntimeException re) {
            try {
                this.doSingleThreadedBatchDelete(emrFsFutureCallback.getResults());
            }
            catch (IOException ioe) {
                LOG.error("Failed to clean up {} on failed rename", (Object)dstDirKey, (Object)ioe);
            }
            throw new IOException(String.format("Failed to copy from %s to %s on rename", srcDirKey, dstDirKey), re);
        }
        try {
            this.doSingleThreadedBatchDelete(keysToRename);
        }
        catch (IOException ioe) {
            throw new IOException(String.format("Failed to delete %s on rename", srcDirKey), ioe);
        }
    }

    private void doSingleThreadedBatchDelete(List<String> keysToDelete) throws IOException {
        this.store.deleteAll(keysToDelete);
    }

    public long getDefaultBlockSize() {
        return ConfigurationUtils.getBlockSize(this.getConf());
    }

    public void setWorkingDirectory(org.apache.hadoop.fs.Path newDir) {
        this.workingDirectory = newDir;
    }

    public org.apache.hadoop.fs.Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public FSDataOutputStream createNonRecursive(org.apache.hadoop.fs.Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String key = this.pathToKey(absolutePath);
        if (key.length() != 0) {
            org.apache.hadoop.fs.Path parent = absolutePath.getParent();
            if (!this.exists(parent)) {
                throw new FileNotFoundException(String.format("Unable to create '%s': parent '%s' was not found.", absolutePath, parent));
            }
            if (!this.isDirectory(parent)) {
                throw new IOException(String.format("Unable to create '%s': parent '%s' is not a directory.", absolutePath, parent));
            }
        }
        return this.create(absolutePath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataInputStream select(org.apache.hadoop.fs.Path path, Configuration selectOptions, int bufferSize) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        FileStatus fs = this.getFileStatus(path);
        if (fs.isDirectory()) {
            throw new IOException("'" + path + "' is a directory");
        }
        LOG.info("Opening S3 Select '" + path + "' for reading");
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String key = this.pathToKey(absolutePath);
        InputStreamWithInfo inputStreamWithInfo = this.store.retrieveSelectObjectContentInputStreamWithInfo(key, selectOptions, 0L);
        FSDataInputStream input = new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new NativeS3FsInputStream(inputStreamWithInfo), bufferSize));
        return input;
    }

    public StagingDirectoryService getStagingDirectoryService() {
        return this.getStagingMechanism();
    }

    private StagingMechanism getStagingMechanism() {
        return this.getFileCreationSubsystem().getStagingMechanism();
    }

    private UploadPlanner getUploadPlanner() {
        return this.getFileCreationSubsystem().getUploadPlanner();
    }

    private FileCreationSubsystem getFileCreationSubsystem() {
        Preconditions.checkState(this.fileCreationSubsystem != null, "FileSystem must be initialized");
        return this.fileCreationSubsystem;
    }

    private final class CacheInvalidator
    extends AfterUploadCompletionObserver {
        @Override
        protected void afterUpload(String bucket, String key) {
            S3NativeFileSystem.this.store.invalidateCache(key);
            S3NativeFileSystem.this.clearCache(key);
        }
    }

    private class NativeS3FsOutputStream
    extends OutputStream
    implements Abortable {
        private final Configuration conf;
        private final NativeFileSystemStore store;
        private final String key;
        private final TemporaryFiles temporaryFiles;
        private final TemporaryDirectories temporaryDirectories;
        private final Path backupFilePath;
        private OutputStream backupStream;
        private MessageDigest digest;
        private boolean closed = false;
        private boolean aborted = false;
        private Progressable progress = null;

        public NativeS3FsOutputStream(Configuration conf, NativeFileSystemStore store, String key, Progressable progress, TemporaryDirectories temporaryDirectories) throws IOException {
            this.conf = conf;
            this.store = store;
            this.key = key;
            this.temporaryDirectories = temporaryDirectories;
            this.temporaryFiles = new TemporaryFiles(temporaryDirectories);
            this.backupFilePath = this.temporaryFiles.create();
            this.progress = progress;
            LOG.info("OutputStream for key '" + key + "' writing to tempfile '" + this.backupFilePath + "'");
            try {
                this.digest = MessageDigest.getInstance("MD5");
                this.backupStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.backupFilePath.toFile()), this.digest));
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn("Cannot load MD5 digest algorithm,skipping message integrity check.", (Throwable)e);
                this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFilePath.toFile()));
            }
        }

        @Override
        public void flush() throws IOException {
            this.backupStream.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.backupStream.close();
                if (this.aborted) {
                    LOG.info("Outputstream for key '" + this.key + "' was aborted, not performing upload.");
                } else {
                    LOG.info("Outputstream for key '" + this.key + "' is being closed. Beginning upload.");
                    byte[] md5Hash = this.digest == null ? null : this.digest.digest();
                    this.store.storeFile(this.key, this.backupFilePath.toFile(), md5Hash, this.progress);
                }
            }
            catch (IOException e) {
                LOG.info("Outputstream for key '" + this.key + "' failed, marking stream as aborted.");
                this.aborted = true;
                throw e;
            }
            catch (RuntimeException e) {
                LOG.info("Outputstream for key '" + this.key + "' failed, marking stream as aborted.");
                this.aborted = true;
                throw e;
            }
            finally {
                this.temporaryFiles.delete(this.backupFilePath);
                this.temporaryDirectories.close();
                super.close();
                this.closed = true;
            }
            LOG.info("OutputStream for key '" + this.key + "': upload complete");
        }

        public synchronized void abort() throws IOException {
            this.aborted = true;
            this.close();
        }

        @Override
        public void write(int writeByte) throws IOException {
            this.backupStream.write(writeByte);
        }

        @Override
        public void write(byte[] writeByte, int off, int len) throws IOException {
            this.backupStream.write(writeByte, off, len);
        }
    }

    private class NativeS3FsInputStream
    extends AbstractS3FSInputStream
    implements CanUnbuffer {
        private InputStreamWithInfo inputStreamWithInfo;
        private final String key;
        private long lastReadPos;
        private long nextReadPos;
        @Nullable
        private Long maxLength;
        private final boolean lazySeek;
        private long readRetryIntervalMS;
        private int fastFirstRetryMS;
        private volatile long contentLength;
        private final AtomicBoolean shouldTryInitialTimeout;

        NativeS3FsInputStream(InputStreamWithInfo inputStreamWithInfo) {
            this(inputStreamWithInfo, 0L, null, ConfigurationUtils.isLazySeekEnabled(s3NativeFileSystem.getConf()), ConfigurationUtils.isPositionedReadOptimizationEnabled(s3NativeFileSystem.getConf()), ConfigurationUtils.getRetryPeriodSeconds(s3NativeFileSystem.getConf()) * 1000, new AtomicBoolean(true));
        }

        private NativeS3FsInputStream(InputStreamWithInfo inputStreamWithInfo, @Nullable long position, Long maxLength, boolean lazySeek, boolean isPositionedReadOptimizationEnabled, long readRetryIntervalMS, AtomicBoolean shouldTryInitialTimeout) {
            super(S3NativeFileSystem.this.store.getBucket(), inputStreamWithInfo.getKey(), !inputStreamWithInfo.isSelect() && isPositionedReadOptimizationEnabled);
            this.inputStreamWithInfo = inputStreamWithInfo;
            this.key = inputStreamWithInfo.getKey();
            this.lastReadPos = position;
            this.nextReadPos = position;
            this.maxLength = maxLength;
            this.lazySeek = lazySeek;
            this.readRetryIntervalMS = readRetryIntervalMS;
            this.contentLength = inputStreamWithInfo.getContentLength();
            this.shouldTryInitialTimeout = shouldTryInitialTimeout;
            this.fastFirstRetryMS = ConfigurationUtils.getFastFirstRetryPeriodMs(S3NativeFileSystem.this.getConf());
        }

        public synchronized int read() throws IOException {
            throw new UnsupportedOperationException("Single byte read() not implemented");
        }

        public synchronized int read(byte[] bytes, int off, int len) throws IOException {
            Preconditions.checkNotNull(bytes, "byte array 'bytes' is required");
            if (off < 0 || len < 0 || len > bytes.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.atEndOfStreamIfKnown()) {
                return -1;
            }
            int numRetries = 5;
            int result = -1;
            Exception lastException = null;
            for (int attempt = 0; attempt < 5; ++attempt) {
                try {
                    if (attempt <= 0) {
                        if (this.lazySeek) {
                            this.seekStream();
                        } else {
                            this.ensureStreamNotClosed();
                        }
                    } else {
                        this.reopenStream();
                    }
                    result = this.inputStreamWithInfo.read(bytes, off, len);
                    if (result > 0) {
                        this.advance(result);
                        break;
                    }
                    if (this.inputStreamWithInfo.shouldBreakReadRetry(this.nextReadPos)) break;
                    LOG.info(this.generateUnexpectedEndOfStreamMsg());
                }
                catch (FileNotFoundException fnfe) {
                    LOG.info("Encountered an exception while reading '{}', file not present", (Object)this.inputStreamWithInfo.getKey(), (Object)fnfe);
                    throw new FileNotFoundException("File not present on S3");
                }
                catch (AmazonClientException | IOException e) {
                    this.shouldTryInitialTimeout.set(false);
                    lastException = e;
                    if (attempt >= 4) {
                        LOG.info("Encountered an exception while reading '{}', max retries exceeded.", (Object)this.inputStreamWithInfo.getKey(), (Object)e);
                    }
                    LOG.info("Encountered an exception while reading '{}', will retry by attempting to reopen stream.", (Object)this.inputStreamWithInfo.getKey(), (Object)e);
                    long retryInterval = RetryUtils.calcRetryInterval(ConfigurationUtils.getRetryPolicyType(S3NativeFileSystem.this.getConf()), this.readRetryIntervalMS, attempt, this.fastFirstRetryMS, e);
                    LOG.debug("Back off {} ms for retrying open stream while reading due to s3 GET-After-PUT consistency issue. For best practice please see https://docs.aws.amazon.com/AmazonS3/latest/dev/Introduction.html#ConsistencyModel", (Object)retryInterval);
                    EmrFsUtils.sleep(retryInterval);
                }
                if (attempt < 4) continue;
                LOG.error("Unable to recover reading from stream");
                throw new IOException(this.generateUnexpectedEndOfStreamMsg(), lastException);
            }
            return result;
        }

        @Override
        protected InputStream forkStream(long position, long maxLength) throws IOException {
            InputStreamWithInfo data = S3NativeFileSystem.this.store.retrieveInputStreamWithInfo(this.key, position, this.contentLength, maxLength, this.shouldTryInitialTimeout.get());
            return new NativeS3FsInputStream(data, position, maxLength, this.lazySeek, false, this.readRetryIntervalMS, this.shouldTryInitialTimeout);
        }

        private String generateUnexpectedEndOfStreamMsg() {
            StringBuilder messageBuilder = new StringBuilder("Unexpected end of stream pos=" + this.lastReadPos);
            if (this.inputStreamWithInfo.isSelect()) {
                messageBuilder.append(", byteScanned=" + this.inputStreamWithInfo.getSelectByteScanned());
            }
            messageBuilder.append(", contentLength=" + this.inputStreamWithInfo.getContentLength());
            return messageBuilder.toString();
        }

        private void advance(int amount) {
            if (this.maxLength != null) {
                Preconditions.checkArgument((long)amount <= this.maxLength, "Cannot advance beyond maxLength");
                this.maxLength = this.maxLength - (long)amount;
            }
            this.lastReadPos += (long)amount;
            this.nextReadPos += (long)amount;
            if (S3NativeFileSystem.this.statistics != null) {
                S3NativeFileSystem.this.statistics.incrementBytesRead((long)amount);
            }
        }

        public void close() throws IOException {
            this.inputStreamWithInfo.close();
        }

        private void retrieveInputStreamWithInfo(long pos) throws IOException {
            if (pos > this.inputStreamWithInfo.getContentLength()) {
                this.throwPositionOutOfBoundsException(pos);
            }
            if (this.atEndOfStreamIfKnown(pos)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream for key '{}' seeking to position '{}'", (Object)this.inputStreamWithInfo.getKey(), (Object)pos);
            }
            this.inputStreamWithInfo = this.inputStreamWithInfo.isSelect() ? S3NativeFileSystem.this.store.retrieveSelectObjectContentInputStreamWithInfo(this.inputStreamWithInfo.getKey(), this.inputStreamWithInfo.getSelectOptions().get(), pos) : S3NativeFileSystem.this.store.retrieveInputStreamWithInfo(this.inputStreamWithInfo.getKey(), pos, null, this.maxLength, this.shouldTryInitialTimeout.get());
            this.contentLength = this.inputStreamWithInfo.getContentLength();
        }

        private boolean atEndOfStreamIfKnown() {
            return this.atEndOfStreamIfKnown(this.nextReadPos);
        }

        private boolean atEndOfStreamIfKnown(long pos) {
            return this.inputStreamWithInfo.atEndOfStreamIfKnown(pos);
        }

        private String throwPositionOutOfBoundsException(long pos) throws EOFException {
            throw new EOFException(String.format("Invalid position: %d, exceeds the bounds of the stream: [0, %d]", pos, this.inputStreamWithInfo.getContentLength()));
        }

        public synchronized void seek(long pos) throws IOException {
            if (this.maxLength != null) {
                throw new UnsupportedOperationException("Seeking is not supported when maxLength is specified");
            }
            if (pos < 0L || pos > this.inputStreamWithInfo.getContentLength()) {
                this.throwPositionOutOfBoundsException(pos);
            }
            this.nextReadPos = pos;
            if (!this.lazySeek) {
                this.seekStream();
            }
        }

        private synchronized void seekStream() throws IOException {
            if (this.lastReadPos == this.nextReadPos && !this.inputStreamWithInfo.wasClosedSuccessfully()) {
                return;
            }
            this.reopenStream();
        }

        private void ensureStreamNotClosed() throws IOException {
            if (this.inputStreamWithInfo.wasClosedSuccessfully()) {
                this.reopenStream();
            }
        }

        private synchronized void reopenStream() throws IOException {
            this.inputStreamWithInfo.close();
            this.retrieveInputStreamWithInfo(this.nextReadPos);
            this.lastReadPos = this.nextReadPos;
        }

        public synchronized long getPos() throws IOException {
            return this.nextReadPos;
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public void unbuffer() {
            try {
                this.inputStreamWithInfo.close();
            }
            catch (IOException e) {
                LOG.warn("Exception while trying to unbuffer input stream: ", (Throwable)e);
            }
        }
    }
}

