/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class S3Credentials {
    private String accessKey;
    private String secretAccessKey;
    private String sessionToken;

    public void initialize(URI uri, Configuration conf) {
        if (EmrFsUtils.uriToBucket(uri) == null) {
            throw new IllegalArgumentException("Invalid hostname in URI " + uri);
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            int index = userInfo.indexOf(58);
            if (index != -1) {
                this.accessKey = userInfo.substring(0, index);
                this.secretAccessKey = userInfo.substring(index + 1);
            } else {
                this.accessKey = userInfo;
            }
        }
        String scheme = uri.getScheme();
        String accessKeyProperty = String.format("fs.%s.awsAccessKeyId", scheme);
        String secretAccessKeyProperty = String.format("fs.%s.awsSecretAccessKey", scheme);
        String sessionTokenProperty = String.format("fs.%s.awsSessionToken", scheme);
        if (this.accessKey == null) {
            this.accessKey = conf.get(accessKeyProperty);
        }
        if (this.secretAccessKey == null) {
            this.secretAccessKey = conf.get(secretAccessKeyProperty);
        }
        if (this.sessionToken == null) {
            this.sessionToken = conf.get(sessionTokenProperty);
        }
        if (this.accessKey == null && this.secretAccessKey == null) {
            throw new IllegalArgumentException("AWS Access Key ID and Secret Access Key must be specified as the username or password (respectively) of a " + scheme + " URL, or by setting the " + accessKeyProperty + " or " + secretAccessKeyProperty + " properties (respectively).");
        }
        if (this.accessKey == null) {
            throw new IllegalArgumentException("AWS Access Key ID must be specified as the username of a " + scheme + " URL, or by setting the " + accessKeyProperty + " property.");
        }
        if (this.secretAccessKey == null) {
            throw new IllegalArgumentException("AWS Secret Access Key must be specified as the password of a " + scheme + " URL, or by setting the " + secretAccessKeyProperty + " property.");
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }
}

