/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.s3.InputStreamWithInfo;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import com.amazon.ws.emr.hadoop.fs.s3n.PartialListing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
public interface NativeFileSystemStore {
    public void initialize(URI var1, Configuration var2) throws IOException;

    public String getBucket();

    public void storeFile(String var1, File var2, byte[] var3, Progressable var4) throws IOException;

    public void storeFile(String var1, File var2, byte[] var3) throws IOException;

    public void storeEmptyFile(String var1) throws IOException;

    public FileMetadata retrieveMetadata(String var1) throws IOException;

    public InputStream retrieve(String var1) throws IOException;

    public InputStream retrieve(String var1, long var2) throws IOException;

    default public InputStreamWithInfo retrieveInputStreamWithInfo(String key, long byteRangeStart) throws IOException {
        return this.retrieveInputStreamWithInfo(key, byteRangeStart, null, null, true);
    }

    public InputStreamWithInfo retrieveInputStreamWithInfo(String var1, long var2, @Nullable Long var4, @Nullable Long var5, boolean var6) throws IOException;

    public PartialListing list(String var1, int var2, String var3, String var4, boolean var5) throws IOException;

    public void delete(String var1) throws IOException;

    public void deleteAll(List<String> var1) throws IOException;

    public void copy(String var1, String var2) throws IOException;

    public List<Callable<String>> createCopyCallables(String var1, String var2) throws IOException;

    public void invalidateCache(String var1);

    @InterfaceStability.Unstable
    public InputStreamWithInfo retrieveSelectObjectContentInputStreamWithInfo(String var1, Configuration var2, long var3) throws IOException;

    public InputStreamWithInfo retrieveClosedInputStreamWithInfo(String var1) throws IOException;
}

