/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.s3.GetObjectInputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.InputStreamWithInfo;
import com.amazon.ws.emr.hadoop.fs.s3.InputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.MultipartCopyManager;
import com.amazon.ws.emr.hadoop.fs.s3.S3ObjectRequestFactory;
import com.amazon.ws.emr.hadoop.fs.s3.S3SelectInputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import com.amazon.ws.emr.hadoop.fs.s3n.NativeFileSystemStore;
import com.amazon.ws.emr.hadoop.fs.s3n.PartialListing;
import com.amazon.ws.emr.hadoop.fs.s3n.ProgressableResettableBufferedFileInputStream;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonServiceException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.S3ObjectId;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Function;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.Cache;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.CacheBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Iterables;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.codec.binary.Base64;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Jets3tNativeFileSystemStore
implements NativeFileSystemStore {
    public static final Logger LOG = LoggerFactory.getLogger(Jets3tNativeFileSystemStore.class);
    private static final int S3_API_MAX_BATCH_SIZE = 1000;
    private static final int MAX_DISPLAY_KEYS = 3;
    private String serverSideEncryptionAlgorithm = null;
    private String serverSideEncryptionKmsKeyId = null;
    private S3ObjectRequestFactory s3ObjectRequestFactory = null;
    private int deleteMaxBatchSize;
    private AmazonS3Lite s3;
    private ListeningExecutorService executorService;
    private String bucket;
    protected Configuration conf;
    Cache<String, FileMetadata> metacache = null;

    public Jets3tNativeFileSystemStore(AmazonS3Lite s3, ListeningExecutorService executorService) {
        this.s3 = s3;
        this.executorService = executorService;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        this.bucket = EmrFsUtils.uriToBucket(uri);
        this.conf = conf;
        this.deleteMaxBatchSize = conf.getInt("fs.s3.delete.maxBatchSize", 1000);
        if (this.deleteMaxBatchSize <= 0 || this.deleteMaxBatchSize > 1000) {
            LOG.warn("Invalid max batch size for delete operations ({}); defaulting to {}", (Object)this.deleteMaxBatchSize, (Object)1000);
            this.deleteMaxBatchSize = 1000;
        }
        if (conf.getBoolean("fs.s3.buckets.create.enabled", false)) {
            this.ensureBucketExists(this.bucket, conf);
        }
        long cacheExpirationSeconds = ConfigurationUtils.getMetadataCacheExpirationSeconds(conf);
        this.metacache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(cacheExpirationSeconds, TimeUnit.SECONDS).build();
        if (ConfigurationUtils.isServerSideEncryptionEnabled(conf)) {
            this.serverSideEncryptionAlgorithm = ConfigurationUtils.getServerSideEncryptionAlgorithm(conf);
            this.serverSideEncryptionKmsKeyId = ConfigurationUtils.getServerSideEncryptionKmsKeyId(conf);
        }
        this.s3ObjectRequestFactory = new S3ObjectRequestFactory(conf, this.serverSideEncryptionKmsKeyId);
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    @Override
    public void invalidateCache(String key) {
        if (this.metacache != null) {
            this.metacache.invalidate(key);
        }
    }

    private void ensureBucketExists(String bucket, Configuration conf) {
        if (!this.s3.doesBucketExist(bucket)) {
            this.s3.createBucket(bucket, conf.get("fs.s3.buckets.create.region"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFile(String key, File file, byte[] md5Hash, Progressable progressable) throws IOException {
        ProgressableResettableBufferedFileInputStream in = null;
        try {
            in = new ProgressableResettableBufferedFileInputStream(file, progressable);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentType("binary/octet-stream");
            metadata.setContentLength(file.length());
            if (md5Hash != null && !ConfigurationUtils.isClientSideEncryptionEnabled(this.conf)) {
                metadata.setContentMD5(new String(Base64.encodeBase64(md5Hash)));
            }
            if (!Strings.isNullOrEmpty(this.serverSideEncryptionAlgorithm)) {
                metadata.setSSEAlgorithm(this.serverSideEncryptionAlgorithm);
            }
            PutObjectRequest request = this.s3ObjectRequestFactory.newPutObjectRequest(this.bucket, key, in, metadata);
            CannedAccessControlList acl = ConfigurationUtils.getAcl(this.conf);
            if (acl != null) {
                request.setCannedAcl(acl);
            }
            this.s3.putObject(request);
            LOG.debug("s3.putObject {} {} {}", new Object[]{this.bucket, key, file.length()});
            this.metacache.invalidate(key);
            CSEUtils.deletePreviousInstructionFileIfNecessary(this.conf, this.s3, this.bucket, key);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void storeFile(String key, File file, byte[] md5Hash) throws IOException {
        this.storeFile(key, file, md5Hash, null);
    }

    @Override
    public void storeEmptyFile(String key) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("binary/octet-stream");
        metadata.setContentLength(0L);
        if (!Strings.isNullOrEmpty(this.serverSideEncryptionAlgorithm)) {
            metadata.setSSEAlgorithm(this.serverSideEncryptionAlgorithm);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest request = this.s3ObjectRequestFactory.newPutObjectRequest(this.bucket, key, in, metadata);
        CannedAccessControlList acl = ConfigurationUtils.getAcl(this.conf);
        if (acl != null) {
            request.setCannedAcl(acl);
        }
        this.s3.putObject(request);
        CSEUtils.deletePreviousInstructionFileIfNecessary(this.conf, this.s3, this.bucket, key);
        this.metacache.invalidate(key);
    }

    @Override
    public FileMetadata retrieveMetadata(String key) throws IOException {
        try {
            FileMetadata fileMetadata = this.metacache.getIfPresent(key);
            if (fileMetadata != null) {
                return fileMetadata;
            }
            ObjectMetadata metadata = this.s3.getObjectMetadata(this.bucket, key);
            long plaintextLength = CSEUtils.getPlaintextLength(this.s3, this.bucket, key, metadata, this.conf);
            LOG.debug("plaintext content length for key {} is: {}", (Object)key, (Object)plaintextLength);
            fileMetadata = new FileMetadata(key, plaintextLength, metadata.getLastModified().getTime());
            this.metacache.put(key, fileMetadata);
            return fileMetadata;
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                if (e.getStatusCode() == 403) {
                    LOG.debug("Cannot get metadata for {} due to {}", (Object)key, (Object)e.getMessage());
                }
                return null;
            }
            throw e;
        }
    }

    @Override
    public InputStream retrieve(String key) throws IOException {
        try {
            S3ObjectInputStream stream = this.s3.getObject(this.bucket, key).getObjectContent();
            return stream;
        }
        catch (AmazonServiceException ase) {
            throw this.handleAmazonServiceException(key, ase);
        }
    }

    @Override
    public InputStream retrieve(String key, long byteRangeStart) throws IOException {
        try {
            FileMetadata metadata = this.retrieveMetadata(key);
            if (metadata == null) {
                throw new FileNotFoundException("Key '" + key + "' does not exist in S3");
            }
            S3ObjectInputStream stream = this.s3.getObject(new GetObjectRequest(this.bucket, key).withRange(byteRangeStart, metadata.getLength())).getObjectContent();
            return stream;
        }
        catch (AmazonServiceException ase) {
            throw this.handleAmazonServiceException(key, ase);
        }
    }

    @Override
    public PartialListing list(String prefix, int maxKeys, String startAfter, String continuationToken, boolean recurse) throws IOException {
        ListObjectsV2Result listing;
        String delimiter;
        String string = delimiter = recurse ? null : "/";
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        try {
            listing = this.s3.listObjectsV2(new ListObjectsV2Request().withBucketName(this.bucket).withPrefix(prefix).withDelimiter(delimiter).withMaxKeys(maxKeys).withStartAfter(startAfter).withContinuationToken(continuationToken));
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        PartialListing output = new PartialListing(startAfter, continuationToken);
        output.addFiles(listing.getObjectSummaries());
        output.addDirs(listing.getCommonPrefixes());
        output.setNextContinuationToken(listing.getNextContinuationToken());
        return output;
    }

    @Override
    public void delete(String key) throws IOException {
        try {
            this.s3.deleteObject(this.bucket, key);
            LOG.debug("s3.deleteObject {} {}", (Object)this.bucket, (Object)key);
            CSEUtils.deletePreviousInstructionFileIfNecessary(this.conf, this.s3, this.bucket, key);
            this.metacache.invalidate(key);
        }
        catch (AmazonServiceException e) {
            throw this.handleAmazonServiceException(key, e);
        }
    }

    private MultipartCopyManager createMultipartCopyManager(String srcKey, String dstKey) {
        return new MultipartCopyManager.Builder().withS3(this.s3).withExecutorService(this.executorService).withSrcBucketName(this.bucket).withSrcKey(srcKey).withDstBucketName(this.bucket).withDstKey(dstKey).withAcl(ConfigurationUtils.getAcl(this.conf)).withServerSideEncryption(this.serverSideEncryptionAlgorithm).withServerSideKmsKeyId(this.serverSideEncryptionKmsKeyId).withConf(this.conf).build();
    }

    @Override
    public void deleteAll(List<String> keys) throws IOException {
        if (keys.size() == 1) {
            this.delete(keys.get(0));
            return;
        }
        if (CSEUtils.shouldDeletePreviousInstructionFiles(this.conf)) {
            keys = Lists.newArrayList(Iterables.concat(keys, Lists.transform(keys, new Function<String, String>(){

                @Override
                public String apply(String key) {
                    return new S3ObjectId(Jets3tNativeFileSystemStore.this.bucket, key).instructionFileId().getKey();
                }
            })));
        }
        List<List<String>> keyBatches = Lists.partition(keys, this.deleteMaxBatchSize);
        Exception firstException = null;
        int numExceptions = 0;
        for (List<String> keyBatch : keyBatches) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("s3.deleteObjects for {} object(s) in bucket {}", (Object)keyBatch.size(), (Object)this.bucket);
                    for (String key : keyBatch) {
                        LOG.debug("s3.deleteObjects batch contains key {}", (Object)key);
                    }
                }
                List<DeleteObjectsRequest.KeyVersion> keyVersionBatch = Lists.transform(keyBatch, new Function<String, DeleteObjectsRequest.KeyVersion>(){

                    @Override
                    public DeleteObjectsRequest.KeyVersion apply(String key) {
                        return new DeleteObjectsRequest.KeyVersion(key);
                    }
                });
                this.s3.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(keyVersionBatch));
                this.metacache.invalidateAll(keyBatch);
            }
            catch (MultiObjectDeleteException e) {
                String message = Jets3tNativeFileSystemStore.formatBatchOperationErrorMessage(e.getClass(), Jets3tNativeFileSystemStore.getErrorKeys(e));
                if (firstException == null) {
                    firstException = new IOException(message, e);
                }
                ++numExceptions;
                LOG.error(message, (Throwable)e);
            }
            catch (AmazonServiceException e) {
                if (firstException == null) {
                    firstException = e;
                }
                ++numExceptions;
                LOG.error("Exception thrown from single batch delete", (Throwable)e);
            }
        }
        if (firstException != null) {
            throw new IOException(String.format("%d exceptions thrown from %d batch deletes", numExceptions, keyBatches.size()), firstException);
        }
    }

    private static List<String> getErrorKeys(MultiObjectDeleteException mode) {
        return Lists.transform(mode.getErrors(), new Function<MultiObjectDeleteException.DeleteError, String>(){

            @Override
            public String apply(MultiObjectDeleteException.DeleteError error) {
                return error.getKey();
            }
        });
    }

    private static String formatBatchOperationErrorMessage(Class<? extends Exception> exceptionType, List<String> errorKeys) {
        int numDisplayErrorKeys = Math.min(3, errorKeys.size());
        List<String> firstKErrorKeys = errorKeys.subList(0, numDisplayErrorKeys);
        StringBuilder sb = new StringBuilder(String.format("%s thrown with %d keys in error: ", exceptionType.getSimpleName(), errorKeys.size()));
        Joiner.on(", ").appendTo(sb, (Iterable<?>)firstKErrorKeys);
        if (numDisplayErrorKeys > errorKeys.size()) {
            sb.append(String.format(" and %d other key(s)", errorKeys.size() - numDisplayErrorKeys));
        }
        return sb.toString();
    }

    @Override
    public void copy(String srcKey, String dstKey) throws IOException {
        try {
            this.createMultipartCopyManager(srcKey, dstKey).copy();
        }
        catch (AmazonServiceException e) {
            throw this.handleAmazonServiceException(srcKey, e);
        }
    }

    @Override
    public List<Callable<String>> createCopyCallables(String srcKey, String dstKey) throws IOException {
        try {
            return this.createMultipartCopyManager(srcKey, dstKey).createCopyCallables();
        }
        catch (AmazonServiceException e) {
            throw this.handleAmazonServiceException(srcKey, e);
        }
    }

    private IOException handleAmazonServiceException(String key, AmazonServiceException ase) throws IOException {
        if ("NoSuchKey".equals(ase.getErrorCode())) {
            return new FileNotFoundException("Key '" + key + "' does not exist in S3");
        }
        throw new IOException(ase);
    }

    @Override
    public InputStreamWithInfo retrieveClosedInputStreamWithInfo(String key) throws IOException {
        try {
            FileMetadata metadata = this.retrieveMetadata(key);
            if (metadata == null) {
                throw new FileNotFoundException("Key '" + key + "' does not exist in S3");
            }
            GetObjectInputStreamWithInfoFactory inputStreamWithInfoFactory = GetObjectInputStreamWithInfoFactory.builder().s3(this.s3).build();
            return inputStreamWithInfoFactory.createClosedStream(this.bucket, key, metadata.getLength());
        }
        catch (AmazonServiceException e) {
            throw this.handleAmazonServiceException(key, e);
        }
    }

    @Override
    public InputStreamWithInfo retrieveInputStreamWithInfo(String key, long byteRangeStart, @Nullable Long contentLength, @Nullable Long maxLength, boolean shouldTryInitialTimeout) throws IOException {
        GetObjectInputStreamWithInfoFactory inputStreamWithInfoFactory = GetObjectInputStreamWithInfoFactory.builder().s3(this.s3).build();
        return this.createInputStreamWithInfoFromFactory(inputStreamWithInfoFactory, key, byteRangeStart, contentLength, maxLength, shouldTryInitialTimeout);
    }

    @Override
    public InputStreamWithInfo retrieveSelectObjectContentInputStreamWithInfo(String key, Configuration selectOptions, long position) throws IOException {
        S3SelectInputStreamWithInfoFactory inputStreamWithInfoFactory = new S3SelectInputStreamWithInfoFactory(this.s3, selectOptions);
        return this.createInputStreamWithInfoFromFactory(inputStreamWithInfoFactory, key, position, null, null, false);
    }

    private InputStreamWithInfo createInputStreamWithInfoFromFactory(InputStreamWithInfoFactory inputStreamWithInfoFactory, String key, long position, @Nullable Long contentLength, @Nullable Long maxLength, boolean shouldTryInitialTimeout) throws IOException {
        try {
            long resolvedContentLength = contentLength == null ? this.getContentLength(key) : contentLength.longValue();
            return inputStreamWithInfoFactory.create(this.bucket, key, position, resolvedContentLength, maxLength, shouldTryInitialTimeout);
        }
        catch (AmazonServiceException e) {
            throw this.handleAmazonServiceException(key, e);
        }
    }

    private long getContentLength(String key) throws IOException {
        FileMetadata metadata = this.retrieveMetadata(key);
        if (metadata == null) {
            throw new FileNotFoundException("Key '" + key + "' does not exist in S3");
        }
        return metadata.getLength();
    }
}

