/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.s3n.S3NativeFileSystem;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStatusCache {
    static final Logger log = LoggerFactory.getLogger(FileStatusCache.class);
    private TreeMap<String, FileStatus> cache = new TreeMap();
    private String listedKey;
    private long lastBuildTime;
    static final long TTL_MILLIS = 120000L;
    private int numCacheHits = 0;
    private int numCacheAccess = 0;
    private long threadId = Thread.currentThread().getId();

    public synchronized void buildCache(TreeMap<String, FileStatus> keys, String listedKey) {
        if (keys != null && keys.size() != 0) {
            this.cache = keys;
            log.info("FileStatusCache-{} {}:{} {} items listedKey {}\n  firstKey: {}\n   lastKey: {}", new Object[]{this.threadId, this.numCacheHits, this.numCacheAccess, keys.size(), listedKey, keys.firstKey(), keys.lastKey()});
        } else {
            this.clearCache();
        }
        this.lastBuildTime = System.currentTimeMillis();
        this.listedKey = listedKey;
    }

    public synchronized void clearCache() {
        if (this.cache.size() > 0) {
            log.info("FileStatusCache-{} cleared {} items", (Object)this.threadId, (Object)this.cache.size());
        }
        this.cache.clear();
        this.lastBuildTime = System.currentTimeMillis();
        this.listedKey = "";
    }

    public synchronized void enforceTTL() {
        if (this.cache.size() > 0 && System.currentTimeMillis() - this.lastBuildTime > 120000L) {
            this.clearCache();
        }
    }

    public synchronized boolean isCached(String key) {
        this.enforceTTL();
        if (this.cache.isEmpty()) {
            return false;
        }
        if (key.compareTo(this.cache.lastKey()) <= 0) {
            if (key.startsWith(this.listedKey)) {
                return true;
            }
            return key.compareTo(this.cache.firstKey()) >= 0;
        }
        return false;
    }

    public synchronized void clearKey(String key) {
        this.enforceTTL();
        if (this.cache.isEmpty()) {
            return;
        }
        if (this.listedKey.startsWith(key)) {
            this.clearCache();
        } else if (key.compareTo(this.listedKey) >= 0 && key.compareTo(this.cache.lastKey()) <= 0) {
            this.clearCache();
        }
    }

    public synchronized FileStatus getFileStatusInner(String key, S3NativeFileSystem parent) {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        String keyFolder = key + "_$folder$";
        if (this.cache.containsKey(keyFolder)) {
            return this.cache.get(keyFolder);
        }
        String dirKey = key + "/";
        if (this.cache.ceilingKey(dirKey) != null && this.cache.ceilingKey(dirKey).startsWith(dirKey)) {
            return parent.newDirectory(new Path("/" + key).makeQualified((FileSystem)parent));
        }
        return null;
    }

    public synchronized FileStatus getFileStatus(String key, S3NativeFileSystem parent) {
        ++this.numCacheAccess;
        FileStatus result = this.getFileStatusInner(key, parent);
        if (result != null) {
            ++this.numCacheHits;
        }
        log.info("FileStatusCache-{} getFileStatus {} {}", new Object[]{this.threadId, key, result != null ? "hit" : "miss"});
        return result;
    }

    public synchronized List<FileStatus> listStatus(String key) {
        ++this.numCacheAccess;
        this.enforceTTL();
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        if (this.cache.containsKey(key)) {
            if (!this.cache.get(key).isDir()) {
                result.add(this.cache.get(key));
            } else if (!this.cache.lastKey().startsWith(key)) {
                key = key + "/";
                SortedMap<String, FileStatus> elements = this.cache.tailMap(key);
                for (String element : elements.keySet()) {
                    if (!element.startsWith(key)) break;
                    if (!this.isImmediateMember(element, key)) continue;
                    result.add((FileStatus)elements.get(element));
                }
            }
        }
        if (result.size() != 0) {
            ++this.numCacheHits;
        }
        log.info("FileStatusCache-{} listStatus {} {} items", new Object[]{this.threadId, key, result.size()});
        return result.size() == 0 ? null : result;
    }

    private void dumpCache(int sampleN) {
        if (this.cache.size() == 0) {
            return;
        }
        if (this.cache.size() < 100) {
            log.info("FileStatusCache {} items:{}", (Object)this.cache.size(), (Object)Joiner.on("\n  ").join(this.cache.keySet()));
        } else {
            int index = -1;
            StringBuilder sb = new StringBuilder();
            for (String v : this.cache.keySet()) {
                if (++index % sampleN != 0 && index != this.cache.size() - 1) continue;
                sb.append(String.format("\n%6d %s", index, v.length() <= 100 ? v : v.substring(0, 50) + "..." + v.substring(v.length() - 50)));
            }
            log.info("FileStatusCache-{} contains {} items:{}", new Object[]{this.threadId, this.cache.size(), sb.toString()});
        }
    }

    private boolean isImmediateMember(String element, String key) {
        return !element.substring(key.length()).contains("/");
    }
}

