/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.plan;

import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.ConditionalUploadPlanner;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.StagingUploadPlanner;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanTemplate;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanner;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlannerChain;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlannerFactory;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingMetadataStore;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPathConverter;
import lombok.NonNull;

public final class StagingAwareUploadPlannerFactory
implements UploadPlannerFactory {
    @NonNull
    private final StagingPathConverter stagingPathConverter;
    @NonNull
    private final StagingMetadataStore stagingMetadataStore;
    @NonNull
    private final UploadPlannerFactory nonStagingPlannerFactory;

    @Override
    public UploadPlanner create(@NonNull UploadPlanTemplate template) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        return UploadPlannerChain.builder().conditionalPlanner(this.createStagingPlanner(template)).fallbackPlanner(this.createFallbackPlanner(template)).build();
    }

    private ConditionalUploadPlanner createStagingPlanner(UploadPlanTemplate template) {
        return StagingUploadPlanner.builder().bucket(template.getBucket()).conf(template.getConfiguration()).multipartDispatcher(template.getMultipartDispatcher()).stagingPathConverter(this.stagingPathConverter).stagingMetadataStore(this.stagingMetadataStore).build();
    }

    private UploadPlanner createFallbackPlanner(UploadPlanTemplate template) {
        return this.nonStagingPlannerFactory.create(template);
    }

    public StagingAwareUploadPlannerFactory(@NonNull StagingPathConverter stagingPathConverter, @NonNull StagingMetadataStore stagingMetadataStore, @NonNull UploadPlannerFactory nonStagingPlannerFactory) {
        if (stagingPathConverter == null) {
            throw new NullPointerException("stagingPathConverter");
        }
        if (stagingMetadataStore == null) {
            throw new NullPointerException("stagingMetadataStore");
        }
        if (nonStagingPlannerFactory == null) {
            throw new NullPointerException("nonStagingPlannerFactory");
        }
        this.stagingPathConverter = stagingPathConverter;
        this.stagingMetadataStore = stagingMetadataStore;
        this.nonStagingPlannerFactory = nonStagingPlannerFactory;
    }
}

