/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.plan;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadConstraint;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanTemplate;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanner;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import com.amazon.ws.emr.hadoop.fs.util.io.IOPredicate;
import java.io.IOException;
import lombok.NonNull;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;

final class RegularUploadPlanner
implements UploadPlanner {
    @NonNull
    private final UploadPlanTemplate template;
    @NonNull
    private final IOPredicate<Path> existenceCheck;

    @Override
    public UploadPlan plan(Path path, boolean overwrite) throws IOException {
        this.checkExistenceIfNotOverwriting(path, overwrite);
        return this.newPlan(path);
    }

    private void checkExistenceIfNotOverwriting(Path path, boolean overwrite) throws IOException {
        if (!overwrite && this.existenceCheck.test(path)) {
            throw new FileAlreadyExistsException("File already exists:" + path);
        }
    }

    private UploadPlan newPlan(Path path) {
        return this.newPlanBuilderFromTemplate().key(EmrFsUtils.pathToKey(path)).extraUploadMetadata(ExtraUploadMetadata.empty()).build();
    }

    private UploadPlan.UploadPlanBuilder newPlanBuilderFromTemplate() {
        UploadPlan.UploadPlanBuilder builder = UploadPlan.builder().bucket(this.template.getBucket()).singlePartDispatcher(this.template.getSinglePartDispatcher());
        if (this.isMultipartUploadEnabled()) {
            builder.multipartDispatcher(this.template.getMultipartDispatcher());
        } else {
            builder.constraint(UploadConstraint.SINGLE_PART_UPLOAD);
        }
        return builder;
    }

    private boolean isMultipartUploadEnabled() {
        return ConfigurationUtils.isMultipartUploadEnabled(this.template.getConfiguration());
    }

    public RegularUploadPlanner(@NonNull UploadPlanTemplate template, @NonNull IOPredicate<Path> existenceCheck) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        if (existenceCheck == null) {
            throw new NullPointerException("existenceCheck");
        }
        this.template = template;
        this.existenceCheck = existenceCheck;
    }
}

