/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public final class UploadObserverContext {
    public static final Store.Key<String> ETAG_VERIFICATION_KEY = Store.Key.named(UploadObserverContext.class, "eTagVerification");
    @NonNull
    private final String bucket;
    @NonNull
    private final String key;
    @NonNull
    private final ExtraUploadMetadata extraUploadMetadata;
    private final Store store = new BasicStore();

    public UploadObserverContext(String bucket, String key) {
        this(bucket, key, ExtraUploadMetadata.empty());
    }

    public UploadObserverContext(@NonNull String bucket, @NonNull String key, @NonNull ExtraUploadMetadata extraUploadMetadata) {
        if (bucket == null) {
            throw new NullPointerException("bucket");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (extraUploadMetadata == null) {
            throw new NullPointerException("extraUploadMetadata");
        }
        this.bucket = bucket;
        this.key = key;
        this.extraUploadMetadata = extraUploadMetadata;
    }

    @NonNull
    public String getBucket() {
        return this.bucket;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public ExtraUploadMetadata getExtraUploadMetadata() {
        return this.extraUploadMetadata;
    }

    public Store getStore() {
        return this.store;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadObserverContext)) {
            return false;
        }
        UploadObserverContext other = (UploadObserverContext)o;
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        ExtraUploadMetadata this$extraUploadMetadata = this.getExtraUploadMetadata();
        ExtraUploadMetadata other$extraUploadMetadata = other.getExtraUploadMetadata();
        if (this$extraUploadMetadata == null ? other$extraUploadMetadata != null : !((Object)this$extraUploadMetadata).equals(other$extraUploadMetadata)) {
            return false;
        }
        Store this$store = this.getStore();
        Store other$store = other.getStore();
        return !(this$store == null ? other$store != null : !this$store.equals(other$store));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        ExtraUploadMetadata $extraUploadMetadata = this.getExtraUploadMetadata();
        result = result * 59 + ($extraUploadMetadata == null ? 43 : ((Object)$extraUploadMetadata).hashCode());
        Store $store = this.getStore();
        result = result * 59 + ($store == null ? 43 : $store.hashCode());
        return result;
    }

    public String toString() {
        return "UploadObserverContext(bucket=" + this.getBucket() + ", key=" + this.getKey() + ", extraUploadMetadata=" + this.getExtraUploadMetadata() + ", store=" + this.getStore() + ")";
    }

    private static final class BasicStore
    implements Store {
        private final Map<Store.Key<?>, Object> storedValues = new HashMap();

        private BasicStore() {
        }

        @Override
        public <T> T get(@NonNull Store.Key<T> key) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            return (T)this.storedValues.get(key);
        }

        @Override
        public <T> void put(@NonNull Store.Key<T> key, T value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            this.storedValues.put(key, value);
        }

        public String toString() {
            return "UploadObserverContext.BasicStore(storedValues=" + this.storedValues + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BasicStore)) {
                return false;
            }
            BasicStore other = (BasicStore)o;
            Map<Store.Key<?>, Object> this$storedValues = this.storedValues;
            Map<Store.Key<?>, Object> other$storedValues = other.storedValues;
            return !(this$storedValues == null ? other$storedValues != null : !((Object)this$storedValues).equals(other$storedValues));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Store.Key<?>, Object> $storedValues = this.storedValues;
            result = result * 59 + ($storedValues == null ? 43 : ((Object)$storedValues).hashCode());
            return result;
        }
    }

    public static interface Store {
        public <T> T get(Key<T> var1);

        public <T> void put(Key<T> var1, T var2);

        public static final class Key<T> {
            private static final String NAMESPACE_SEPARATOR = "#";
            @NonNull
            private final String name;

            public static <T> Key<T> named(@NonNull Class<?> namespace, @NonNull String name) {
                if (namespace == null) {
                    throw new NullPointerException("namespace");
                }
                if (name == null) {
                    throw new NullPointerException("name");
                }
                return Key.named(namespace.getName() + NAMESPACE_SEPARATOR + name);
            }

            private Key(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name");
                }
                this.name = name;
            }

            public static <T> Key<T> named(@NonNull String name) {
                return new Key<T>(name);
            }

            @NonNull
            public String getName() {
                return this.name;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Key)) {
                    return false;
                }
                Key other = (Key)o;
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }

            public String toString() {
                return "UploadObserverContext.Store.Key(name=" + this.getName() + ")";
            }
        }
    }
}

