/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.AfterUploadCompletionObserver;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonServiceException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import java.io.IOException;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnencryptedLengthHeaderAdder
extends AfterUploadCompletionObserver {
    private static final Logger logger = LoggerFactory.getLogger(UnencryptedLengthHeaderAdder.class);
    @NonNull
    private final AmazonS3Lite s3;
    @NonNull
    private final Configuration configuration;

    @Override
    protected void afterUpload(String bucket, String key) throws IOException {
        if (!ConfigurationUtils.isCSEUnencryptedLengthHeaderMPUEnabled(this.configuration).booleanValue()) {
            logger.debug("Not adding the unencrypted length header");
            return;
        }
        try {
            logger.info("Going to add unencrypted length header to {}/{}", (Object)bucket, (Object)key);
            ObjectMetadata copyMetadata = this.s3.getObjectMetadata(bucket, key);
            long len = CSEUtils.getPlaintextLength(this.s3, bucket, key, copyMetadata, true);
            logger.debug("Determined unencrypted length for {}/{} as {}", new Object[]{bucket, key, len});
            copyMetadata.addUserMetadata("x-amz-unencrypted-content-length", String.valueOf(len));
            CopyObjectRequest request = new CopyObjectRequest(bucket, key, bucket, key).withNewObjectMetadata(copyMetadata);
            this.s3.copyObject(request);
            logger.info("Added the unencrypted length header to {}/{}", (Object)bucket, (Object)key);
        }
        catch (Exception e) {
            if (e instanceof AmazonServiceException && ((AmazonServiceException)e).getStatusCode() == 404) {
                return;
            }
            logger.error("Error trying to add unencrypted length header to {}/{}", new Object[]{bucket, key, e});
            throw new IOException(e);
        }
    }

    public UnencryptedLengthHeaderAdder(@NonNull AmazonS3Lite s3, @NonNull Configuration configuration) {
        if (s3 == null) {
            throw new NullPointerException("s3");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.s3 = s3;
        this.configuration = configuration;
    }
}

