/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.AfterUploadCompletionObserver;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import java.io.IOException;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreviousInstructionFileDeleter
extends AfterUploadCompletionObserver {
    private static final Logger logger = LoggerFactory.getLogger(PreviousInstructionFileDeleter.class);
    @NonNull
    private final AmazonS3Lite s3;
    @NonNull
    private final Configuration configuration;

    @Override
    protected void afterUpload(String bucket, String key) throws IOException {
        try {
            CSEUtils.deletePreviousInstructionFileIfNecessary(this.configuration, this.s3, bucket, key);
        }
        catch (AmazonClientException e) {
            logger.debug("Unable to delete instruction file for {}/{}", (Object)bucket, (Object)key);
            throw new IOException(e);
        }
    }

    public PreviousInstructionFileDeleter(@NonNull AmazonS3Lite s3, @NonNull Configuration configuration) {
        if (s3 == null) {
            throw new NullPointerException("s3");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.s3 = s3;
        this.configuration = configuration;
    }
}

