/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.consistency.Entities;
import com.amazon.ws.emr.hadoop.fs.consistency.ItemKeys;
import com.amazon.ws.emr.hadoop.fs.consistency.concurrent.ConcurrencyToken;
import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ConcurrencyTokenResolver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserverContext;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserverContexts;
import java.io.IOException;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class DefaultConcurrencyTokenResolver
implements ConcurrencyTokenResolver {
    @NonNull
    private final EntityStore<Entity> entityStore;

    @Override
    public ConcurrencyToken resolve(UploadObserverContext context) throws IOException {
        ConcurrencyToken token = this.getConcurrencyTokenFromContext(context);
        return token != null ? token : this.getNewConcurrencyToken(context);
    }

    private ConcurrencyToken getConcurrencyTokenFromContext(UploadObserverContext context) {
        ExtraUploadMetadata metadata = context.getExtraUploadMetadata();
        return metadata.getConcurrencyToken();
    }

    private ConcurrencyToken getNewConcurrencyToken(UploadObserverContext context) throws IOException {
        ItemKey itemKey = UploadObserverContexts.getItemKey(context);
        Entity entity = this.entityStore.retrieve(itemKey);
        this.checkNotDirectory(entity);
        return ConcurrencyToken.of(entity);
    }

    private void checkNotDirectory(@Nullable Entity entity) throws IOException {
        if (Entities.isDirectory(entity)) {
            throw new IOException(String.format("Metadata at '%s' is for an existent directory", ItemKeys.toPathString(entity.getItemKey())));
        }
    }

    public DefaultConcurrencyTokenResolver(@NonNull EntityStore<Entity> entityStore) {
        if (entityStore == null) {
            throw new NullPointerException("entityStore");
        }
        this.entityStore = entityStore;
    }
}

