/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.EmrFsStore;
import com.amazon.ws.emr.hadoop.fs.consistency.ItemKeys;
import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreException;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreExceptionCode;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserverContext;
import java.io.IOException;
import lombok.NonNull;

public class CopyMetadataObserver
implements UploadObserver {
    @NonNull
    private final EntityStore<Entity> entityStore;

    @Override
    public void beforeUploadCompletion(UploadObserverContext context) throws IOException {
    }

    @Override
    public void afterUploadCompletion(UploadObserverContext context) throws IOException {
        if (!CSEUtils.isInstructionFile(context.getKey())) {
            this.createMetadata(context);
        }
    }

    private void createMetadata(UploadObserverContext context) throws IOException {
        EmrFsStore.MetadataFile metadataFile = EmrFsStore.MetadataFile.newBuilder().setIsDirectory(false).setState(EmrFsStore.MetadataFile.State.PUT).setVersion(1).build();
        String etag = context.getStore().get(UploadObserverContext.ETAG_VERIFICATION_KEY);
        ItemKey itemKey = ItemKeys.toItemKey(context.getBucket(), context.getKey());
        try {
            this.entityStore.create(new Entity(itemKey, metadataFile.toByteArray()).withEtag(etag));
        }
        catch (EntityStoreException e) {
            this.handleEntityStoreCreateException(e, itemKey, metadataFile, etag);
        }
    }

    private void handleEntityStoreCreateException(EntityStoreException e, ItemKey itemKey, EmrFsStore.MetadataFile metadata, String etag) throws IOException {
        Entity entity;
        EmrFsStore.MetadataFile currentMetadata;
        if ((e.getEntityStoreExceptionCode() == EntityStoreExceptionCode.ALREADY_EXISTS || e.getEntityStoreExceptionCode() == EntityStoreExceptionCode.STALE_ENTITY) && (currentMetadata = EmrFsStore.MetadataFile.parseFrom((entity = this.entityStore.retrieve(itemKey)).getPayload())).getState() == EmrFsStore.MetadataFile.State.DELETED) {
            entity.setDeletionTTL(0L);
            entity.setPayload(metadata.toByteArray());
            entity.setEtag(etag);
            try {
                this.entityStore.update(entity);
                return;
            }
            catch (EntityStoreException ex) {
                if (ex.getEntityStoreExceptionCode() == EntityStoreExceptionCode.STALE_ENTITY) {
                    return;
                }
                e = ex;
            }
        }
        throw new IOException(e);
    }

    public CopyMetadataObserver(@NonNull EntityStore<Entity> entityStore) {
        if (entityStore == null) {
            throw new NullPointerException("entityStore");
        }
        this.entityStore = entityStore;
    }
}

