/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PartETag;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.List;
import lombok.NonNull;

public final class CompleteMultipartUploadEvent {
    private final String bucket;
    private final String key;
    private final String uploadId;
    private final List<PartETag> partETags;
    private final Long totalLength;
    private final ExtraUploadMetadata extraUploadMetadata;

    private CompleteMultipartUploadEvent(@NonNull String bucket, @NonNull String key, @NonNull String uploadId, @NonNull List<PartETag> partETags, @NonNull Long totalLength, @NonNull ExtraUploadMetadata extraUploadMetadata) {
        if (bucket == null) {
            throw new NullPointerException("bucket");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (uploadId == null) {
            throw new NullPointerException("uploadId");
        }
        if (partETags == null) {
            throw new NullPointerException("partETags");
        }
        if (totalLength == null) {
            throw new NullPointerException("totalLength");
        }
        if (extraUploadMetadata == null) {
            throw new NullPointerException("extraUploadMetadata");
        }
        Preconditions.checkArgument(totalLength >= 0L, "TotalLength (%s) must not be negative", totalLength);
        this.bucket = bucket;
        this.key = key;
        this.uploadId = uploadId;
        this.partETags = partETags;
        this.totalLength = totalLength;
        this.extraUploadMetadata = extraUploadMetadata;
    }

    public static CompleteMultipartUploadEventBuilder builder() {
        return new CompleteMultipartUploadEventBuilder();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public List<PartETag> getPartETags() {
        return this.partETags;
    }

    public Long getTotalLength() {
        return this.totalLength;
    }

    public ExtraUploadMetadata getExtraUploadMetadata() {
        return this.extraUploadMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompleteMultipartUploadEvent)) {
            return false;
        }
        CompleteMultipartUploadEvent other = (CompleteMultipartUploadEvent)o;
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$uploadId = this.getUploadId();
        String other$uploadId = other.getUploadId();
        if (this$uploadId == null ? other$uploadId != null : !this$uploadId.equals(other$uploadId)) {
            return false;
        }
        List<PartETag> this$partETags = this.getPartETags();
        List<PartETag> other$partETags = other.getPartETags();
        if (this$partETags == null ? other$partETags != null : !((Object)this$partETags).equals(other$partETags)) {
            return false;
        }
        Long this$totalLength = this.getTotalLength();
        Long other$totalLength = other.getTotalLength();
        if (this$totalLength == null ? other$totalLength != null : !((Object)this$totalLength).equals(other$totalLength)) {
            return false;
        }
        ExtraUploadMetadata this$extraUploadMetadata = this.getExtraUploadMetadata();
        ExtraUploadMetadata other$extraUploadMetadata = other.getExtraUploadMetadata();
        return !(this$extraUploadMetadata == null ? other$extraUploadMetadata != null : !((Object)this$extraUploadMetadata).equals(other$extraUploadMetadata));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $uploadId = this.getUploadId();
        result = result * 59 + ($uploadId == null ? 43 : $uploadId.hashCode());
        List<PartETag> $partETags = this.getPartETags();
        result = result * 59 + ($partETags == null ? 43 : ((Object)$partETags).hashCode());
        Long $totalLength = this.getTotalLength();
        result = result * 59 + ($totalLength == null ? 43 : ((Object)$totalLength).hashCode());
        ExtraUploadMetadata $extraUploadMetadata = this.getExtraUploadMetadata();
        result = result * 59 + ($extraUploadMetadata == null ? 43 : ((Object)$extraUploadMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "CompleteMultipartUploadEvent(bucket=" + this.getBucket() + ", key=" + this.getKey() + ", uploadId=" + this.getUploadId() + ", partETags=" + this.getPartETags() + ", totalLength=" + this.getTotalLength() + ", extraUploadMetadata=" + this.getExtraUploadMetadata() + ")";
    }

    public static class CompleteMultipartUploadEventBuilder {
        private String bucket;
        private String key;
        private String uploadId;
        private List<PartETag> partETags;
        private Long totalLength;
        private ExtraUploadMetadata extraUploadMetadata;

        CompleteMultipartUploadEventBuilder() {
        }

        public CompleteMultipartUploadEventBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public CompleteMultipartUploadEventBuilder key(String key) {
            this.key = key;
            return this;
        }

        public CompleteMultipartUploadEventBuilder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public CompleteMultipartUploadEventBuilder partETags(List<PartETag> partETags) {
            this.partETags = partETags;
            return this;
        }

        public CompleteMultipartUploadEventBuilder totalLength(Long totalLength) {
            this.totalLength = totalLength;
            return this;
        }

        public CompleteMultipartUploadEventBuilder extraUploadMetadata(ExtraUploadMetadata extraUploadMetadata) {
            this.extraUploadMetadata = extraUploadMetadata;
            return this;
        }

        public CompleteMultipartUploadEvent build() {
            return new CompleteMultipartUploadEvent(this.bucket, this.key, this.uploadId, this.partETags, this.totalLength, this.extraUploadMetadata);
        }

        public String toString() {
            return "CompleteMultipartUploadEvent.CompleteMultipartUploadEventBuilder(bucket=" + this.bucket + ", key=" + this.key + ", uploadId=" + this.uploadId + ", partETags=" + this.partETags + ", totalLength=" + this.totalLength + ", extraUploadMetadata=" + this.extraUploadMetadata + ")";
        }
    }
}

