/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import lombok.NonNull;

public final class AbortMultipartUploadEvent {
    @NonNull
    private final String bucket;
    @NonNull
    private final String key;
    @NonNull
    private final String uploadId;

    AbortMultipartUploadEvent(@NonNull String bucket, @NonNull String key, @NonNull String uploadId) {
        if (bucket == null) {
            throw new NullPointerException("bucket");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (uploadId == null) {
            throw new NullPointerException("uploadId");
        }
        this.bucket = bucket;
        this.key = key;
        this.uploadId = uploadId;
    }

    public static AbortMultipartUploadEventBuilder builder() {
        return new AbortMultipartUploadEventBuilder();
    }

    @NonNull
    public String getBucket() {
        return this.bucket;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public String getUploadId() {
        return this.uploadId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbortMultipartUploadEvent)) {
            return false;
        }
        AbortMultipartUploadEvent other = (AbortMultipartUploadEvent)o;
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$uploadId = this.getUploadId();
        String other$uploadId = other.getUploadId();
        return !(this$uploadId == null ? other$uploadId != null : !this$uploadId.equals(other$uploadId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $uploadId = this.getUploadId();
        result = result * 59 + ($uploadId == null ? 43 : $uploadId.hashCode());
        return result;
    }

    public String toString() {
        return "AbortMultipartUploadEvent(bucket=" + this.getBucket() + ", key=" + this.getKey() + ", uploadId=" + this.getUploadId() + ")";
    }

    public static class AbortMultipartUploadEventBuilder {
        private String bucket;
        private String key;
        private String uploadId;

        AbortMultipartUploadEventBuilder() {
        }

        public AbortMultipartUploadEventBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public AbortMultipartUploadEventBuilder key(String key) {
            this.key = key;
            return this;
        }

        public AbortMultipartUploadEventBuilder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public AbortMultipartUploadEvent build() {
            return new AbortMultipartUploadEvent(this.bucket, this.key, this.uploadId);
        }

        public String toString() {
            return "AbortMultipartUploadEvent.AbortMultipartUploadEventBuilder(bucket=" + this.bucket + ", key=" + this.key + ", uploadId=" + this.uploadId + ")";
        }
    }
}

