/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.select;

import com.amazon.ws.emr.hadoop.fs.s3.select.RequestGenerateUtils;
import com.amazon.ws.emr.hadoop.fs.s3.select.RequestSerializationGenerator;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CSVInput;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CSVOutput;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.FileHeaderInfo;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.InputSerialization;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.OutputSerialization;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;

final class CSVRequestSerializationGenerator
extends RequestSerializationGenerator {
    CSVRequestSerializationGenerator(Configuration selectOptions) {
        super(selectOptions);
    }

    @Override
    protected InputSerialization setInputFormat(InputSerialization inputSerialization) {
        CSVInput csvInput = new CSVInput();
        String header = this.selectOptions.get("fs.s3.select.csv.header");
        if (StringUtils.isNotEmpty(header)) {
            FileHeaderInfo fileHeaderInfo = FileHeaderInfo.fromValue(header.toUpperCase(Locale.ENGLISH));
            csvInput.setFileHeaderInfo(fileHeaderInfo);
        }
        csvInput.setComments(RequestGenerateUtils.unescapeJava(this.selectOptions.get("fs.s3.select.csv.comment.marker", "#")));
        csvInput.setFieldDelimiter(RequestGenerateUtils.unescapeJava(this.selectOptions.get("fs.s3.select.csv.field.delimiter", ",")));
        csvInput.setRecordDelimiter(RequestGenerateUtils.unescapeJava(this.selectOptions.get("fs.s3.select.csv.record.delimiter", "\n")));
        csvInput.setQuoteCharacter(RequestGenerateUtils.unescapeJava(this.selectOptions.get("fs.s3.select.csv.quote.character", "\"")));
        csvInput.setQuoteEscapeCharacter(RequestGenerateUtils.unescapeJava(this.selectOptions.get("fs.s3.select.csv.quote.escape.character", "\"")));
        return inputSerialization.withCsv(csvInput);
    }

    @Override
    protected OutputSerialization setOutputFormat(OutputSerialization outputSerialization) {
        CSVOutput csvOutput = new CSVOutput();
        String outputFieldDelimiter = this.selectOptions.get("fs.s3.select.csv.output.field.delimiter", this.selectOptions.get("fs.s3.select.csv.field.delimiter", ","));
        csvOutput.setFieldDelimiter(RequestGenerateUtils.unescapeJava(outputFieldDelimiter));
        String outputRecordDelimiter = this.selectOptions.get("fs.s3.select.csv.output.record.delimiter", this.selectOptions.get("fs.s3.select.csv.record.delimiter", "\n"));
        csvOutput.setRecordDelimiter(RequestGenerateUtils.unescapeJava(outputRecordDelimiter));
        String outputQuoteChar = this.selectOptions.get("fs.s3.select.csv.output.quote.character", this.selectOptions.get("fs.s3.select.csv.quote.character", "\""));
        csvOutput.setQuoteCharacter(RequestGenerateUtils.unescapeJava(outputQuoteChar));
        String outputQuoteEscapeChar = this.selectOptions.get("fs.s3.select.csv.output.quote.escape.character", this.selectOptions.get("fs.s3.select.csv.quote.escape.character", "\""));
        csvOutput.setQuoteEscapeCharacter(RequestGenerateUtils.unescapeJava(outputQuoteEscapeChar));
        String outputQuoteFields = this.selectOptions.get("fs.s3.select.csv.output.quote.fields", "ASNEEDED");
        csvOutput.setQuoteFields(outputQuoteFields);
        return outputSerialization.withCsv(csvOutput);
    }
}

