/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.provider;

import com.amazon.ws.emr.hadoop.fs.s3.lite.factory.S3Factory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.provider.S3Provider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonWebServiceClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.handlers.RequestHandler2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3Client;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.CacheBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.CacheLoader;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.LoadingCache;
import java.util.List;
import javax.annotation.Nullable;

public final class DefaultS3Provider<C extends AmazonS3Client, S>
implements S3Provider<C> {
    private final S3Factory<C, S> s3Factory;
    private final List<? extends RequestHandler2> requestHandlers;
    private final LoadingCache<String, C> clientCache;
    private final LoadingCache<String, C> InitialTimeoutClientCache;
    private final boolean isInitialTimeoutSet;

    public DefaultS3Provider(S3Factory<C, S> s3Factory, S s3Configuration, @Nullable S initialTimeoutS3Configuration, List<? extends RequestHandler2> requestHandlers) {
        Preconditions.checkNotNull(s3Factory, "S3Factory is required");
        Preconditions.checkNotNull(s3Configuration, "S3Configuration is required");
        Preconditions.checkNotNull(requestHandlers, "RequestHandlers are required");
        this.s3Factory = s3Factory;
        this.requestHandlers = requestHandlers;
        this.clientCache = CacheBuilder.newBuilder().build(new S3CacheLoader(s3Configuration));
        this.isInitialTimeoutSet = initialTimeoutS3Configuration != null;
        this.InitialTimeoutClientCache = this.isInitialTimeoutSet ? CacheBuilder.newBuilder().build(new S3CacheLoader(initialTimeoutS3Configuration)) : null;
    }

    @Override
    public C getS3(String endpoint) {
        return (C)((AmazonS3Client)this.clientCache.getUnchecked(endpoint));
    }

    @Override
    public C getS3WithInitialTimeoutOrS3Default(String endpoint) {
        return (C)(this.isInitialTimeoutSet() ? (AmazonS3Client)this.InitialTimeoutClientCache.getUnchecked(endpoint) : this.getS3(endpoint));
    }

    @Override
    public boolean isInitialTimeoutSet() {
        return this.isInitialTimeoutSet;
    }

    private class S3CacheLoader
    extends CacheLoader<String, C> {
        S s3Configuration;

        S3CacheLoader(S s3Configuration) {
            this.s3Configuration = s3Configuration;
        }

        @Override
        public C load(String endpoint) {
            AmazonS3Client client = (AmazonS3Client)((AmazonWebServiceClient)this.newClient()).withEndpoint(endpoint);
            this.addRequestHandlers(client);
            return client;
        }

        private C newClient() {
            return (AmazonS3Client)DefaultS3Provider.this.s3Factory.newS3(this.s3Configuration);
        }

        private void addRequestHandlers(C s3) {
            for (RequestHandler2 requestHandler : DefaultS3Provider.this.requestHandlers) {
                ((AmazonWebServiceClient)s3).addRequestHandler(requestHandler);
            }
        }
    }
}

