/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.configuration;

import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.AbstractS3Configuration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;

public final class S3EncryptionConfiguration
extends AbstractS3Configuration {
    private final EncryptionMaterialsProvider encryptionMaterialsProvider;
    private final CryptoConfiguration cryptoConfiguration;

    private S3EncryptionConfiguration(Builder builder) {
        super(builder);
        this.encryptionMaterialsProvider = builder.encryptionMaterialsProvider;
        this.cryptoConfiguration = builder.cryptoConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EncryptionMaterialsProvider getEncryptionMaterialsProvider() {
        return this.encryptionMaterialsProvider;
    }

    public CryptoConfiguration getCryptoConfiguration() {
        return this.cryptoConfiguration;
    }

    public static final class Builder
    extends AbstractS3Configuration.Builder<S3EncryptionConfiguration, Builder> {
        private EncryptionMaterialsProvider encryptionMaterialsProvider;
        private CryptoConfiguration cryptoConfiguration;

        private Builder() {
        }

        public Builder encryptionMaterialsProvider(EncryptionMaterialsProvider encryptionMaterialsProvider) {
            this.encryptionMaterialsProvider = encryptionMaterialsProvider;
            return this;
        }

        public Builder cryptoConfiguration(CryptoConfiguration cryptoConfiguration) {
            this.cryptoConfiguration = cryptoConfiguration;
            return this;
        }

        @Override
        S3EncryptionConfiguration newInstance() {
            Preconditions.checkNotNull(this.encryptionMaterialsProvider, "EncryptionMaterialsProvider is required");
            Preconditions.checkNotNull(this.cryptoConfiguration, "CryptoConfiguration is required");
            return new S3EncryptionConfiguration(this);
        }
    }
}

