/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.call;

import com.amazon.ws.emr.hadoop.fs.s3.lite.S3Constants;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Call;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resource;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resources;
import com.amazon.ws.emr.hadoop.fs.s3.lite.exception.RepeatS3CallException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3;
import com.amazon.ws.emr.hadoop.fs.util.io.RestartableInputStream;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
abstract class AbstractUploadingS3Call<O, I extends AmazonWebServiceRequest, C extends AmazonS3>
implements S3Call<O, C>,
Closeable {
    private final RestartableInputStream inputStream;
    private final I request;

    protected AbstractUploadingS3Call(I request) {
        this.inputStream = this.wrapInputStreamIfPresent(request);
        this.request = this.replaceInputStream(request, this.inputStream);
    }

    @Override
    public String getBucketName() {
        return this.getBucketName(this.request);
    }

    @Override
    public O perform(C client) {
        if (this.inputStream != null) {
            try {
                this.inputStream.restart();
            }
            catch (IOException e) {
                throw new RepeatS3CallException("Cannot restart input stream for S3 call", e);
            }
        }
        return this.performCall(client, this.request);
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.release();
        }
    }

    protected abstract String getBucketName(I var1);

    protected abstract String getKey(I var1);

    protected abstract InputStream getInputStream(I var1);

    protected abstract I cloneWithInputStream(I var1, InputStream var2);

    protected abstract O performCall(C var1, I var2);

    private RestartableInputStream wrapInputStreamIfPresent(I request) {
        InputStream in = this.getInputStream(request);
        if (in == null) {
            return null;
        }
        return new RestartableInputStream(in, AbstractUploadingS3Call.getReadLimit(request));
    }

    private I replaceInputStream(I request, InputStream in) {
        if (in == null) {
            return request;
        }
        return this.cloneWithInputStream(request, in);
    }

    private static int getReadLimit(AmazonWebServiceRequest request) {
        Integer s3StreamBufferSize = S3Constants.getS3StreamBufferSize();
        if (s3StreamBufferSize != null) {
            return s3StreamBufferSize;
        }
        return request.getRequestClientOptions().getReadLimit();
    }

    @Override
    public void setCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        ((AmazonWebServiceRequest)this.request).setRequestCredentialsProvider(credentialsProvider);
    }

    @Override
    public Collection<S3Resource> getS3Resources() {
        return S3Resources.fromBucketAndKey(this.getBucketName(this.request), this.getKey(this.request));
    }

    @Override
    public void enableRequesterPays() {
        ((AmazonWebServiceRequest)this.request).putCustomRequestHeader("x-amz-request-payer", "requester");
    }
}

