/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.AwsHostNameUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public final class S3Errors {
    private static final String ENDPOINT_KEY = "Endpoint";

    private S3Errors() {
        throw new AssertionError();
    }

    public static boolean isPermanentRedirect(AmazonS3Exception exception) {
        S3Errors.checkExceptionNotNull(exception);
        return exception.getStatusCode() == 301;
    }

    public static boolean isHttp200WithErrorCode(AmazonS3Exception exception) {
        S3Errors.checkExceptionNotNull(exception);
        return exception.getStatusCode() == 200 && StringUtils.isNotEmpty(Optional.ofNullable(exception.getErrorCode()).orElse("").trim());
    }

    @Nullable
    public static String getBucketRegion(AmazonS3Exception exception) {
        S3Errors.checkExceptionNotNull(exception);
        Map<String, String> additionalDetails = exception.getAdditionalDetails();
        if (additionalDetails != null) {
            String bucketRegion = additionalDetails.get("x-amz-bucket-region");
            if (bucketRegion != null) {
                return bucketRegion;
            }
            String endpoint = additionalDetails.get(ENDPOINT_KEY);
            if (endpoint != null) {
                return S3Errors.parseRegionName(endpoint);
            }
        }
        return null;
    }

    private static void checkExceptionNotNull(AmazonS3Exception exception) {
        Preconditions.checkNotNull(exception, "AmazonS3Exception is required");
    }

    private static String parseRegionName(String endpoint) {
        return AwsHostNameUtils.parseRegionName(endpoint, "s3");
    }
}

