/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite;

import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3LiteClient;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3LiteClientFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.DefaultAmazonS3LiteClientFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.bucket.BucketRegionStores;
import com.amazon.ws.emr.hadoop.fs.s3.lite.executor.SimpleS3Executor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;

public final class AmazonS3LiteClients {
    private static final AmazonS3LiteClientFactory defaultFactory = new DefaultAmazonS3LiteClientFactory(BucketRegionStores.inMemoryStore());

    private AmazonS3LiteClients() {
        throw new AssertionError();
    }

    @VisibleForTesting
    public static AmazonS3Lite newClient(AmazonS3 client) {
        Preconditions.checkNotNull(client, "Client is required");
        return new AmazonS3LiteClient<AmazonS3>(new SimpleS3Executor<AmazonS3>(client));
    }

    public static AmazonS3LiteClientFactory defaultFactory() {
        return defaultFactory;
    }
}

