/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.s3.InputStreamWithInfo;
import com.amazon.ws.emr.hadoop.fs.s3.InputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.select.SelectObjectRequestGenerator;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazon.ws.emr.hadoop.fs.util.MorePreconditions;
import java.io.EOFException;
import java.io.IOException;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;

public class S3SelectInputStreamWithInfoFactory
implements InputStreamWithInfoFactory {
    @NonNull
    private final AmazonS3Lite s3;
    @NonNull
    private final Configuration selectOptions;

    @Override
    public InputStreamWithInfo create(@NonNull String bucket, @NonNull String key, long position, long contentLength, @Nullable Long maxLength, boolean shouldTryInitialTimeout) throws IOException {
        if (bucket == null) {
            throw new NullPointerException("bucket");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.checkContentLength(contentLength);
        this.checkPosition(position, contentLength);
        this.checkMaxLengthNotSet(maxLength);
        InputStreamWithInfo stream = this.createStream(bucket, key, contentLength);
        this.skipStreamToPosition(stream, position);
        return stream;
    }

    @Override
    public InputStreamWithInfo createClosedStream(String bucket, String key, long contentLength) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void checkContentLength(long contentLength) {
        MorePreconditions.checkNotNegative(contentLength, "content length");
    }

    private void checkPosition(long position, long contentLength) throws EOFException {
        MorePreconditions.checkNotNegative(position, "position");
        if (position > contentLength) {
            throw new EOFException(String.format("Invalid position: %d, exceeds the bounds of the stream: [0, %d]", position, contentLength));
        }
    }

    private void checkMaxLengthNotSet(@Nullable Long maxLength) {
        if (maxLength != null) {
            throw new UnsupportedOperationException(String.format("%s does not support specifying a max length", this.getClass().getSimpleName()));
        }
    }

    private InputStreamWithInfo createStream(String bucket, String key, long contentLength) {
        SelectObjectContentRequest request = SelectObjectRequestGenerator.generateRequestFromConfiguration(bucket, key, this.selectOptions);
        SelectObjectContentResult result = this.s3.selectObjectContent(request);
        return new InputStreamWithInfo(result.getPayload(), key, this.selectOptions, contentLength);
    }

    private void skipStreamToPosition(InputStreamWithInfo stream, long position) throws IOException {
        long skippedBytes;
        if (position > 0L && (skippedBytes = stream.skip(position)) != position) {
            String msg = String.format("Unable to start from position %d, actually skipped %d. Might be because the position exceeds the bounds of response stream", position, skippedBytes);
            throw new IOException(msg);
        }
    }

    public S3SelectInputStreamWithInfoFactory(@NonNull AmazonS3Lite s3, @NonNull Configuration selectOptions) {
        if (s3 == null) {
            throw new NullPointerException("s3");
        }
        if (selectOptions == null) {
            throw new NullPointerException("selectOptions");
        }
        this.s3 = s3;
        this.selectOptions = selectOptions;
    }
}

