/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.s3.EmrFSDataInputStreamBuilder;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataInputStreamBuilder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.staging.StagingDirectoryCapable;
import org.apache.hadoop.fs.staging.UnsupportedStagingDirectoryOperationException;

public abstract class S3NativeCommonFileSystem
extends FileSystem
implements StagingDirectoryCapable {
    public FSDataInputStreamBuilder openFile(Path path) {
        return new EmrFSDataInputStreamBuilder(this, path);
    }

    protected abstract FSDataInputStream select(Path var1, Configuration var2, int var3) throws IOException;

    protected final void checkNotStagingDirectoryPath(Path path) throws IOException {
        if (this.getStagingDirectoryService().isStagingDirectoryPath(path)) {
            throw new UnsupportedStagingDirectoryOperationException(String.format("Paths under staging directories are not supported (%s)", path));
        }
    }
}

