/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectories;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryFiles;
import com.amazon.ws.emr.hadoop.fs.s3.MultipartUploadManager;
import com.amazon.ws.emr.hadoop.fs.s3.S3ObjectRequestFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ObjectCreationEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadConstraint;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.s3n.ProgressableResettableBufferedFileInputStream;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.event.ProgressEvent;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.event.ProgressListener;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Throwables;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.codec.binary.Base64;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.common.Abortable;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FSOutputStream
extends OutputStream
implements Abortable {
    private static final Logger LOG = LoggerFactory.getLogger(S3FSOutputStream.class);
    private OutputStream localFileStream;
    private Path localPath;
    private MessageDigest digest;
    private long contentLength;
    private long currentPartLength;
    private boolean isClosed = false;
    private MultipartUploadManager multipartUpload = null;
    private final AmazonS3Lite s3;
    private final String uniqueFileId = UUID.randomUUID().toString();
    private final String bucketName;
    private final String key;
    private final long PART_SIZE_DEFAULT = 0x8000000L;
    private long partSize;
    private final Progressable progress;
    private final Configuration configuration;
    private final ListeningExecutorService executorService;
    private final UploadPlan uploadPlan;
    private final ProgressListener progressListener;
    private final String serverSideEncryptionAlgorithm;
    private final String serverSideEncryptionKmsKeyId;
    private final S3ObjectRequestFactory s3ObjectRequestFactory;
    private final ExecutorService progressExecutor;
    private final int INTERNAL_BUFFER_SIZE = 524288;
    private final ByteBuffer internalBuffer;
    private final long S3_MIN_PART_SIZE = 0x500000L;
    private final TemporaryDirectories temporaryDirectories;
    private final TemporaryFiles temporaryFiles;

    public S3FSOutputStream(AmazonS3Lite s3, UploadPlan uploadPlan, String serverSideEncryptionAlgorithm, String serverSideEncryptionKmsKeyId, ListeningExecutorService executorService, Progressable progressable, Configuration configuration, TemporaryDirectories temporaryDirectories) {
        Preconditions.checkArgument(uploadPlan.getConstraint() != UploadConstraint.SINGLE_PART_UPLOAD, "S3FSOutputStream cannot be used when constrained to single part uploads");
        this.uploadPlan = uploadPlan;
        this.bucketName = uploadPlan.getBucket();
        this.key = uploadPlan.getKey();
        this.progress = progressable;
        this.configuration = configuration;
        this.s3 = s3;
        this.serverSideEncryptionAlgorithm = serverSideEncryptionAlgorithm;
        this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        this.s3ObjectRequestFactory = new S3ObjectRequestFactory(configuration, serverSideEncryptionKmsKeyId);
        this.partSize = configuration.getLong("fs.s3n.multipart.uploads.split.size", 0x8000000L);
        if (this.partSize < 0x500000L) {
            LOG.warn("fs.s3n.multipart.uploads.split.size = {} is too small, setting to min {}", (Object)this.partSize, (Object)0x500000L);
            this.partSize = 0x500000L;
        }
        this.executorService = executorService;
        this.internalBuffer = ByteBuffer.allocate(524288);
        this.progressExecutor = new ThreadPoolExecutor(1, 3, 20L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(100), new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("progress-reporter" + this.threadCount++);
                thread.setDaemon(true);
                return thread;
            }
        }, new ThreadPoolExecutor.DiscardOldestPolicy());
        ProgressListener progressListener = null;
        if (this.progress != null) {
            progressListener = new ProgressListener(){

                @Override
                public void progressChanged(ProgressEvent progressEvent) {
                    S3FSOutputStream.this.progressExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            S3FSOutputStream.this.progress.progress();
                        }
                    });
                }
            };
            progressListener.progressChanged(null);
        }
        this.progressListener = progressListener;
        this.temporaryDirectories = temporaryDirectories;
        this.temporaryFiles = new TemporaryFiles(temporaryDirectories);
    }

    public void abort() throws IOException {
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.internalBuffer.position() > 0) {
            LOG.debug("flushing the internal buffer.");
            this.writeInternal(this.internalBuffer.array(), 0, this.internalBuffer.position());
            this.internalBuffer.clear();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.doClose();
        }
        catch (IOException | RuntimeException e) {
            this.releaseResourcesIfNeededThenRethrow(e);
        }
        finally {
            this.temporaryDirectories.close();
        }
        LOG.debug("Closed {}:{}", (Object)this.bucketName, (Object)this.key);
    }

    private void doClose() throws IOException {
        LOG.debug("Closing {}:{}", (Object)this.bucketName, (Object)this.key);
        this.flush();
        if (this.localFileStream == null) {
            this.startNewTempFile();
        }
        this.localFileStream.close();
        if (this.constrainedToMultipartUpload()) {
            this.ensureMultipartUploadIsInitiated();
        }
        if (this.multipartUpload != null) {
            this.finishMultipartUpload();
        } else {
            this.uploadSingleCompleteFile();
        }
    }

    private void releaseResourcesIfNeededThenRethrow(Exception thrown) throws IOException {
        this.closeLocalFileStreamIfNotNull(thrown);
        this.abortMultipartUploadIfInProgress(thrown);
        S3FSOutputStream.rethrowAsIsOrWrapped(thrown);
    }

    private void closeLocalFileStreamIfNotNull(Exception thrown) {
        if (this.localFileStream != null) {
            this.closeLocalFileStreamOnFailure(thrown);
        }
    }

    private void closeLocalFileStreamOnFailure(Exception thrown) {
        try {
            this.localFileStream.close();
        }
        catch (IOException | RuntimeException closeException) {
            LOG.error("Error closing local file output stream at {}", (Object)this.localPath, (Object)closeException);
            thrown.addSuppressed(closeException);
        }
    }

    private void abortMultipartUploadIfInProgress(Exception thrown) {
        if (this.isMultipartUploadInProgress()) {
            this.abortMultipartUploadOnFailure(thrown);
        }
    }

    private boolean isMultipartUploadInProgress() {
        return this.multipartUpload != null && this.multipartUpload.isInProgress();
    }

    private void abortMultipartUploadOnFailure(Exception thrown) {
        try {
            this.multipartUpload.abort();
        }
        catch (IOException | RuntimeException abortException) {
            LOG.error("Error aborting multipart upload for bucket '{}' key '{}'", new Object[]{this.bucketName, this.key, abortException});
            thrown.addSuppressed(abortException);
        }
    }

    private void finishMultipartUpload() throws IOException {
        if (this.shouldUploadFinalPartBeforeCommitting()) {
            this.uploadFinalPartBeforeCommitting();
        }
        this.multipartUpload.commit();
    }

    private boolean shouldUploadFinalPartBeforeCommitting() {
        boolean hasRemainingBytesToUpload = this.currentPartLength > 0L;
        boolean needsEmptyPartUploaded = this.contentLength == 0L;
        return hasRemainingBytesToUpload || needsEmptyPartUploaded;
    }

    private void uploadFinalPartBeforeCommitting() throws IOException {
        if (this.contentLength < this.partSize) {
            this.uploadOnlyPartSynchronously();
        } else {
            this.uploadPartAsynchronously();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len > this.internalBuffer.remaining()) {
            this.writeInternal(this.internalBuffer.array(), 0, this.internalBuffer.position());
            this.internalBuffer.clear();
            if (len > this.internalBuffer.remaining()) {
                this.writeInternal(b, off, len);
            } else {
                this.internalBuffer.put(b, off, len);
            }
        } else {
            this.internalBuffer.put(b, off, len);
        }
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            long useLen;
            if (this.progressListener != null) {
                this.progressListener.progressChanged(null);
            }
            if ((useLen = (long)len) + this.currentPartLength > this.partSize) {
                useLen = this.partSize - this.currentPartLength;
            }
            if (useLen > 0L) {
                if (this.localFileStream == null) {
                    this.startNewTempFile();
                }
                this.localFileStream.write(b, off, (int)useLen);
                this.currentPartLength += useLen;
                this.contentLength += useLen;
                off = (int)((long)off + useLen);
                len = (int)((long)len - useLen);
            }
            if (this.currentPartLength < this.partSize) continue;
            this.uploadPartAsynchronously();
        }
    }

    private boolean constrainedToMultipartUpload() {
        return this.uploadPlan.getConstraint() == UploadConstraint.MULTIPART_UPLOAD;
    }

    private void ensureMultipartUploadIsInitiated() throws IOException {
        if (this.multipartUpload == null) {
            this.multipartUpload = this.buildMultipartUploadManager();
            this.multipartUpload.start();
        }
    }

    @VisibleForTesting
    MultipartUploadManager buildMultipartUploadManager() {
        return new MultipartUploadManager.Builder().withUploadPlan(this.uploadPlan).withUploadId(this.uniqueFileId).withServerSideEncryptionAlgorithm(this.serverSideEncryptionAlgorithm).withServerSideKmsKeyId(this.serverSideEncryptionKmsKeyId).withS3(this.s3).withExecutorService(this.executorService).withProgressable(this.progress).withConf(this.configuration).withMaxPartSize(this.partSize).withTemporaryFiles(this.temporaryFiles).build();
    }

    private void uploadPartAsynchronously() throws IOException {
        this.ensureMultipartUploadIsInitiated();
        this.localFileStream.close();
        this.multipartUpload.addPartAsynchronously(this.localPath);
        this.resetLocalFileReferences();
    }

    private void uploadOnlyPartSynchronously() throws IOException {
        this.ensureMultipartUploadIsInitiated();
        this.localFileStream.close();
        this.multipartUpload.addOnlyPartSynchronously(this.localPath);
        this.resetLocalFileReferences();
    }

    private void startNewTempFile() throws IOException {
        this.currentPartLength = 0L;
        this.localPath = this.createTemporaryFile();
        try {
            this.digest = MessageDigest.getInstance("MD5");
            this.localFileStream = new BufferedOutputStream(new DigestOutputStream(this.createLocalFileStream(), this.digest));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot load MD5 digest algorithm, skipping message integrity check.", (Throwable)e);
            this.localFileStream = new BufferedOutputStream(this.createLocalFileStream());
        }
        LOG.debug("Started new temp file with path {}", (Object)this.localPath.toAbsolutePath());
    }

    @VisibleForTesting
    Path createTemporaryFile() throws IOException {
        return this.temporaryFiles.create();
    }

    @VisibleForTesting
    OutputStream createLocalFileStream() throws FileNotFoundException {
        return new FileOutputStream(this.localPath.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadSingleCompleteFile() throws IOException {
        try (ProgressableResettableBufferedFileInputStream inputStream = new ProgressableResettableBufferedFileInputStream(this.localPath.toFile(), null);){
            this.uploadPlan.getSinglePartDispatcher().create(this.newObjectCreationEvent(inputStream));
        }
        finally {
            this.temporaryFiles.delete(this.localPath);
            this.resetLocalFileReferences();
        }
    }

    private ObjectCreationEvent newObjectCreationEvent(InputStream inputStream) throws IOException {
        ObjectCreationEvent.ObjectCreationEventBuilder eventBuilder = ObjectCreationEvent.builder().bucket(this.bucketName).key(this.key).contentStream(inputStream).contentLength(Files.size(this.localPath)).serverSideEncryptionAlgorithm(this.serverSideEncryptionAlgorithm).progressListener(this.progressListener).extraUploadMetadata(this.uploadPlan.getExtraUploadMetadata());
        if (this.digest != null) {
            eventBuilder.contentMD5(new String(Base64.encodeBase64(this.digest.digest())));
        }
        return eventBuilder.build();
    }

    private void resetLocalFileReferences() {
        this.localPath = null;
        this.localFileStream = null;
        this.currentPartLength = 0L;
    }

    private static void rethrowAsIsOrWrapped(Exception thrown) throws IOException {
        Throwables.propagateIfPossible(thrown, IOException.class);
        throw new RuntimeException(thrown);
    }
}

