/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.internal.SdkFilterInputStream;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SelectObjectContentEvent;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SelectObjectContentEventStream;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SelectObjectContentEventVisitor;
import com.amazon.ws.emr.hadoop.fs.util.MorePreconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.NonNull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@NotThreadSafe
public class InputStreamWithInfo
extends InputStream {
    public static final Logger LOG = LoggerFactory.getLogger(InputStreamWithInfo.class);
    private final InputStream in;
    private final long contentLength;
    @Nullable
    private final Long maxRequestedBytes;
    private final String key;
    private final Optional<Configuration> selectOptions;
    private final AtomicBoolean isSelectResultComplete = new AtomicBoolean(false);
    private final AtomicLong selectByteScanned = new AtomicLong(0L);
    private final AtomicLong selectByteReturned = new AtomicLong(0L);
    private boolean wasClosedSuccessfully = false;
    private boolean eofReached;
    private long bytesRead;
    private long markedBytes;

    public InputStreamWithInfo(@NonNull InputStream inputStream, @NonNull String key, long contentLength) {
        this(inputStream, key, contentLength, null);
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
    }

    public InputStreamWithInfo(@NonNull InputStream inputStream, @NonNull String key, long contentLength, @Nullable Long maxRequestedBytes) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        InputStreamWithInfo.checkMaxRequestedBytes(maxRequestedBytes);
        this.in = inputStream;
        this.key = key;
        this.contentLength = contentLength;
        this.maxRequestedBytes = maxRequestedBytes;
        this.selectOptions = Optional.empty();
    }

    public InputStreamWithInfo(@NonNull String key, long contentLength) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.contentLength = contentLength;
        this.key = key;
        this.selectOptions = Optional.empty();
        this.wasClosedSuccessfully = true;
        this.in = null;
        this.maxRequestedBytes = 0L;
    }

    public InputStreamWithInfo(@NonNull SelectObjectContentEventStream eventStream, final @NonNull String key, @NonNull Configuration selectOptions, long contentLength) {
        if (eventStream == null) {
            throw new NullPointerException("eventStream");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (selectOptions == null) {
            throw new NullPointerException("selectOptions");
        }
        this.in = eventStream.getRecordsInputStream(new SelectObjectContentEventVisitor(){

            @Override
            public void visit(SelectObjectContentEvent.EndEvent event) {
                LOG.debug("Select object content of '{}' received EndEvent", (Object)key);
                InputStreamWithInfo.this.isSelectResultComplete.set(true);
            }

            @Override
            public void visit(SelectObjectContentEvent.ProgressEvent event) {
                InputStreamWithInfo.this.selectByteScanned.set(event.getDetails().getBytesScanned());
                InputStreamWithInfo.this.selectByteReturned.set(event.getDetails().getBytesReturned());
                InputStreamWithInfo.this.logSelectProcessDetails();
            }

            @Override
            public void visit(SelectObjectContentEvent.StatsEvent event) {
                InputStreamWithInfo.this.selectByteScanned.set(event.getDetails().getBytesScanned());
                InputStreamWithInfo.this.selectByteReturned.set(event.getDetails().getBytesReturned());
                InputStreamWithInfo.this.logSelectProcessDetails();
            }
        });
        this.key = key;
        this.selectOptions = Optional.of(selectOptions);
        this.contentLength = contentLength;
        this.maxRequestedBytes = null;
    }

    public Optional<Configuration> getSelectOptions() {
        if (this.isSelect()) {
            return Optional.of(new Configuration(this.selectOptions.get()));
        }
        return Optional.empty();
    }

    public boolean isSelect() {
        return this.selectOptions.isPresent();
    }

    boolean isSelectResultComplete() {
        return this.isSelectResultComplete.get();
    }

    public long getSelectByteScanned() {
        return this.selectByteScanned.get();
    }

    long getSelectByteReturned() {
        return this.selectByteReturned.get();
    }

    public boolean atEndOfStreamIfKnown(long pos) {
        if (!this.isSelect()) {
            return pos == this.getContentLength();
        }
        return this.isSelectResultComplete() && pos == this.getSelectByteReturned();
    }

    public boolean shouldBreakReadRetry(long pos) {
        return this.contentLength == -1L || this.atEndOfStreamIfKnown(pos);
    }

    private void logSelectProcessDetails() {
        LOG.debug("Select object content of '{}' scanned {} bytes, returned {} bytes", new Object[]{this.getKey(), this.selectByteScanned.get(), this.selectByteReturned.get()});
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getKey() {
        return this.key;
    }

    public boolean wasClosedSuccessfully() {
        return this.wasClosedSuccessfully;
    }

    @Override
    public int read() throws IOException {
        this.checkInitialized();
        int value = this.in.read();
        boolean bl = this.eofReached = value == -1;
        if (!this.eofReached) {
            ++this.bytesRead;
        }
        return value;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        this.checkInitialized();
        int readCount = this.in.read(bytes, off, len);
        boolean bl = this.eofReached = readCount == -1;
        if (!this.eofReached) {
            this.bytesRead += (long)readCount;
        }
        return readCount;
    }

    @Override
    public long skip(long num) throws IOException {
        this.checkInitialized();
        long skipped = this.in.skip(num);
        if (skipped > 0L) {
            this.bytesRead += skipped;
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        this.checkInitialized();
        return this.in.available();
    }

    private void checkInitialized() throws IOException {
        if (this.in == null) {
            throw new IOException("The input stream has not been initialized. Reopen IStream");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.wasClosedSuccessfully) {
            return;
        }
        try {
            if (this.in != null) {
                if (this.in instanceof SdkFilterInputStream && !this.wereAllBytesRead()) {
                    ((SdkFilterInputStream)this.in).abort();
                } else {
                    this.in.close();
                }
            }
            this.wasClosedSuccessfully = true;
        }
        catch (Exception e) {
            LOG.warn("Exception closing input stream. ", (Throwable)e);
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.in != null) {
            this.in.mark(readlimit);
            this.markedBytes = this.bytesRead;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("mark/reset not supported");
        }
        this.checkInitialized();
        this.in.reset();
        this.bytesRead = this.markedBytes;
        this.eofReached = false;
    }

    @Override
    public boolean markSupported() {
        if (this.in == null) {
            return false;
        }
        return this.in.markSupported();
    }

    private boolean wereAllBytesRead() {
        return this.eofReached || this.maxRequestedBytes != null && this.bytesRead >= this.maxRequestedBytes;
    }

    private static void checkMaxRequestedBytes(@Nullable Long maxRequestedBytes) {
        if (maxRequestedBytes != null) {
            MorePreconditions.checkNotNegative(maxRequestedBytes, "max requested bytes");
        }
    }
}

