/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.io.IOUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSInputStream;

@InterfaceAudience.Private
public abstract class AbstractS3FSInputStream
extends FSInputStream {
    private final String bucket;
    private final String key;
    private final boolean optimizePositionedRead;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if (!this.optimizePositionedRead) {
            return super.read(position, buffer, offset, length);
        }
        this.validatePositionedReadArgs(position, buffer, offset, length);
        Preconditions.checkPositionIndex(offset, buffer.length, "offset");
        if (length == 0) {
            return 0;
        }
        try (InputStream input = this.forkStream(position, length);){
            int bytesRead = IOUtils.read(input, buffer, offset, length);
            int n = bytesRead > 0 ? bytesRead : -1;
            return n;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        if (!this.optimizePositionedRead) {
            super.readFully(position, buffer, offset, length);
        } else {
            int bytesRead = this.read(position, buffer, offset, length);
            if (bytesRead != length) {
                throw new EOFException("End of file reached before reading fully.: bucket=" + this.bucket + ", key=" + this.key + ", position=" + position + ", request length=" + length);
            }
        }
    }

    protected abstract InputStream forkStream(long var1, long var3) throws IOException;

    protected AbstractS3FSInputStream(String bucket, String key, boolean optimizePositionedRead) {
        this.bucket = bucket;
        this.key = key;
        this.optimizePositionedRead = optimizePositionedRead;
    }
}

