/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.rolemapping;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMapping;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingBuilder;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingContext;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingType;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UserRoleMapping
extends RoleMapping {
    private static final Logger LOG = LoggerFactory.getLogger(UserRoleMapping.class);
    private final String roleArn;
    private final String[] usernames;

    private UserRoleMapping(String roleArn, String[] usernames) {
        this.roleArn = roleArn;
        this.usernames = usernames;
    }

    @Override
    boolean appliesTo(RoleMappingContext context) {
        FileSystemOwner fileSystemOwner = context.getFileSystemOwner();
        if (fileSystemOwner == null) {
            return false;
        }
        for (String user : this.usernames) {
            if (!user.equals(fileSystemOwner.getShortUserName())) continue;
            LOG.debug("Matching {} : {} with {}", new Object[]{this, user, fileSystemOwner});
            return true;
        }
        return false;
    }

    @Override
    boolean isValid() {
        return UserRoleMapping.isRoleArnValid(this.roleArn) && this.usernames.length > 0 && Arrays.stream(this.usernames).map(u -> !u.isEmpty()).reduce(true, Boolean::logicalAnd) != false;
    }

    @Override
    String getRoleArn() {
        return this.roleArn;
    }

    @Override
    String[] getTargets() {
        return this.usernames;
    }

    @Override
    RoleMappingType getType() {
        return RoleMappingType.USER;
    }

    static UserRoleMappingBuilder builder() {
        return new UserRoleMappingBuilder();
    }

    static class UserRoleMappingBuilder
    extends RoleMappingBuilder {
        private UserRoleMappingBuilder() {
        }

        @Override
        UserRoleMapping build() {
            return new UserRoleMapping(super.getRoleArn(), super.getTargets());
        }
    }
}

