/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.rolemapping;

import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMapping;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingBuilder;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingContext;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingType;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resource;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PrefixRoleMapping
extends RoleMapping {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixRoleMapping.class);
    private final String roleArn;
    private final String[] prefixes;

    private PrefixRoleMapping(String roleArn, String[] prefixes) {
        this.roleArn = roleArn;
        this.prefixes = prefixes;
    }

    @Override
    boolean appliesTo(RoleMappingContext context) {
        Collection<S3Resource> s3Resources = context.getS3Resources();
        if (s3Resources == null) {
            return false;
        }
        for (String mappingS3Path : this.prefixes) {
            String mappingPath;
            String mappingBucket;
            boolean allResourcesApply = true;
            if ((mappingS3Path = PrefixRoleMapping.sanitizeS3Path(mappingS3Path)).indexOf(47) == -1) {
                mappingBucket = mappingS3Path;
                mappingPath = "";
            } else {
                mappingBucket = mappingS3Path.substring(0, mappingS3Path.indexOf(47));
                mappingPath = mappingS3Path.substring((mappingBucket + "/").length());
            }
            for (S3Resource requiredResource : s3Resources) {
                String requiredPath = "";
                if (requiredResource.getPath() != null) {
                    requiredPath = requiredResource.getPath();
                }
                if (mappingBucket.equals(requiredResource.getBucketName()) && requiredPath.startsWith(mappingPath)) continue;
                allResourcesApply = false;
                break;
            }
            if (!allResourcesApply) continue;
            LOG.debug("Matching {} : {} with {}", new Object[]{this, this.prefixes, s3Resources});
            return true;
        }
        return false;
    }

    @Override
    boolean isValid() {
        boolean prefixesAreValid = true;
        try {
            for (String s3Path : this.prefixes) {
                PrefixRoleMapping.sanitizeS3Path(s3Path);
            }
        }
        catch (IllegalArgumentException e) {
            prefixesAreValid = false;
        }
        return PrefixRoleMapping.isRoleArnValid(this.roleArn) && this.prefixes.length > 0 && Arrays.stream(this.prefixes).map(p -> !p.isEmpty()).reduce(true, Boolean::logicalAnd) != false && prefixesAreValid;
    }

    @Override
    String getRoleArn() {
        return this.roleArn;
    }

    @Override
    String[] getTargets() {
        return this.prefixes;
    }

    @Override
    RoleMappingType getType() {
        return RoleMappingType.PREFIX;
    }

    static PrefixRoleMappingBuilder builder() {
        return new PrefixRoleMappingBuilder();
    }

    static class PrefixRoleMappingBuilder
    extends RoleMappingBuilder {
        private PrefixRoleMappingBuilder() {
        }

        @Override
        PrefixRoleMapping build() {
            return new PrefixRoleMapping(super.getRoleArn(), super.getTargets());
        }
    }
}

